<?php

namespace App\Models {

    /**
     * App\Models\BaseModel
     *
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel query()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static BaseModel|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel clone()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static BaseModel|null first(array|string $columns)
     * @method static BaseModel firstOrFail(array|string $columns, string|null $message)
     * @method static BaseModel sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<BaseModel>|BaseModel tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class BaseModel extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\ChunkedUpload
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array|null $metadata
     * @property integer $total_chunks
     * @property integer $chunks_completed
     * @property string $status
     * @property string|null $key
     * @property string|null $upload_id
     * @property integer $size
     * @property string|null $mime_type
     * @property string $disk
     * @property string|null $file_url
     * @property string|null $file_path
     * @property string $original_filename
     * @property string $filename
     * @property int $user_id
     * @property int $id
     * @property-read \App\Models\User $user
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereFilename($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereOriginalFilename($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereFilePath($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereFileUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereDisk($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereMimeType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereSize($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereUploadId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereChunksCompleted($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereTotalChunks($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereMetadata($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload query()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static ChunkedUpload|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload clone()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static ChunkedUpload|null first(array|string $columns)
     * @method static ChunkedUpload firstOrFail(array|string $columns, string|null $message)
     * @method static ChunkedUpload sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<ChunkedUpload>|ChunkedUpload tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class ChunkedUpload extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\DeviceIp
     *
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp query()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static DeviceIp|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp clone()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static DeviceIp|null first(array|string $columns)
     * @method static DeviceIp firstOrFail(array|string $columns, string|null $message)
     * @method static DeviceIp sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<DeviceIp>|DeviceIp tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class DeviceIp extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Footer
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $active
     * @property string $slug
     * @property string $title
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\FooterItem> $footerItems
     * @property-read int|null $footerItems_count
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer query()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Footer|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Footer|null first(array|string $columns)
     * @method static Footer firstOrFail(array|string $columns, string|null $message)
     * @method static Footer sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Footer>|Footer tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Footer extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\FooterItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $footer_id
     * @property array|null $items
     * @property boolean $active
     * @property string $title
     * @property string $slug
     * @property string $type
     * @property integer $sort
     * @property int $id
     * @property-read \App\Models\Footer $footer
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereSort($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereItems($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereFooterId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem query()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static FooterItem|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem clone()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static FooterItem|null first(array|string $columns)
     * @method static FooterItem firstOrFail(array|string $columns, string|null $message)
     * @method static FooterItem sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<FooterItem>|FooterItem tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class FooterItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Instructor
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $user_id
     * @property array $payout_methods
     * @property string $status
     * @property string $designation
     * @property string $resume
     * @property string $biography
     * @property array $skills
     * @property int $id
     * @property-read \App\Models\User $user
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Course\Course> $courses
     * @property-read int|null $courses_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Modules\Exam\Models\Exam> $exams
     * @property-read int|null $exams_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
     * @property-read int|null $media_count
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereSkills($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereBiography($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereResume($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereDesignation($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor wherePayoutMethods($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor query()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Instructor|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Instructor|null first(array|string $columns)
     * @method static Instructor firstOrFail(array|string $columns, string|null $message)
     * @method static Instructor sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Instructor>|Instructor tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Instructor extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\JobCircular
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $status
     * @property string $work_type
     * @property string $job_type
     * @property integer $positions_available
     * @property array|null $skills_required
     * @property string $contact_email
     * @property \Illuminate\Support\Carbon $application_deadline
     * @property boolean $salary_negotiable
     * @property string $salary_currency
     * @property decimal:2|null $salary_max
     * @property decimal:2|null $salary_min
     * @property string $location
     * @property string $experience_level
     * @property string $description
     * @property string $slug
     * @property string $title
     * @property int $id
     * @property-read mixed $formatted_salary
     * @property-read mixed $time_until_deadline
     * @property-read mixed $is_expired
     * @property-read mixed $is_published
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereExperienceLevel($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereLocation($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSalaryMin($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSalaryMax($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSalaryCurrency($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSalaryNegotiable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereApplicationDeadline($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereContactEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSkillsRequired($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular wherePositionsAvailable($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJobType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereWorkType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular active()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular published()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular notExpired()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular byJobType()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular byExperienceLevel()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular byWorkType()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular query()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static JobCircular|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular clone()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static JobCircular|null first(array|string $columns)
     * @method static JobCircular firstOrFail(array|string $columns, string|null $message)
     * @method static JobCircular sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<JobCircular>|JobCircular tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class JobCircular extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Navbar
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property boolean $active
     * @property string $slug
     * @property string $title
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\NavbarItem> $navbarItems
     * @property-read int|null $navbarItems_count
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar query()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Navbar|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Navbar|null first(array|string $columns)
     * @method static Navbar firstOrFail(array|string $columns, string|null $message)
     * @method static Navbar sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Navbar>|Navbar tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Navbar extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\NavbarItem
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $navbar_id
     * @property boolean $active
     * @property array|null $items
     * @property string|null $value
     * @property string $title
     * @property string $slug
     * @property string $type
     * @property integer $sort
     * @property int $id
     * @property-read \App\Models\Navbar $navbar
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereSort($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereValue($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereItems($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNavbarId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem query()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static NavbarItem|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem clone()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static NavbarItem|null first(array|string $columns)
     * @method static NavbarItem firstOrFail(array|string $columns, string|null $message)
     * @method static NavbarItem sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<NavbarItem>|NavbarItem tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class NavbarItem extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Newsletter
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $description
     * @property string $subject
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereSubject($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter query()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Newsletter|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Newsletter|null first(array|string $columns)
     * @method static Newsletter firstOrFail(array|string $columns, string|null $message)
     * @method static Newsletter sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Newsletter>|Newsletter tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Newsletter extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Page
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $meta_keywords
     * @property string|null $meta_description
     * @property string|null $description
     * @property string|null $favicon
     * @property string|null $banner
     * @property string $title
     * @property string $type
     * @property string $slug
     * @property string $name
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\PageSection> $sections
     * @property-read int|null $sections_count
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereBanner($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereFavicon($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereMetaDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereMetaKeywords($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page query()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Page|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Page|null first(array|string $columns)
     * @method static Page firstOrFail(array|string $columns, string|null $message)
     * @method static Page sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Page>|Page tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Page extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PageSection
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $page_id
     * @property boolean $active
     * @property array|null $properties
     * @property array|null $flags
     * @property string|null $video_url
     * @property string|null $background_color
     * @property string|null $background_image
     * @property string|null $thumbnail
     * @property string|null $description
     * @property string|null $sub_title
     * @property string|null $title
     * @property integer $sort
     * @property string $slug
     * @property string $name
     * @property int $id
     * @property-read \App\Models\Page $page
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
     * @property-read int|null $media_count
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereSlug($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereSort($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereSubTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereDescription($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereThumbnail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereBackgroundImage($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereBackgroundColor($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereVideoUrl($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereFlags($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereProperties($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereActive($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection wherePageId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection query()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PageSection|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PageSection|null first(array|string $columns)
     * @method static PageSection firstOrFail(array|string $columns, string|null $message)
     * @method static PageSection sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PageSection>|PageSection tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PageSection extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\PasswordResetToken
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $token
     * @property string $email
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken query()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static PasswordResetToken|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken clone()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static PasswordResetToken|null first(array|string $columns)
     * @method static PasswordResetToken firstOrFail(array|string $columns, string|null $message)
     * @method static PasswordResetToken sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<PasswordResetToken>|PasswordResetToken tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class PasswordResetToken extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Setting
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property array $fields
     * @property string $title
     * @property string|null $sub_type
     * @property string $type
     * @property int $id
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
     * @property-read int|null $media_count
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereSubType($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTitle($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereFields($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting ofType()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting ofSubType()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting query()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Setting|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Setting|null first(array|string $columns)
     * @method static Setting firstOrFail(array|string $columns, string|null $message)
     * @method static Setting sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Setting>|Setting tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Setting extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\Subscribe
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string $email
     * @property int $id
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe query()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static Subscribe|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe clone()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static Subscribe|null first(array|string $columns)
     * @method static Subscribe firstOrFail(array|string $columns, string|null $message)
     * @method static Subscribe sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<Subscribe>|Subscribe tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class Subscribe extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\TempStore
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property int $user_id
     * @property array|null $properties
     * @property string|null $key
     * @property int $id
     * @property-read \App\Models\User $user
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereKey($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereProperties($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereUserId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore query()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static TempStore|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore clone()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static TempStore|null first(array|string $columns)
     * @method static TempStore firstOrFail(array|string $columns, string|null $message)
     * @method static TempStore sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<TempStore>|TempStore tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class TempStore extends \Illuminate\Database\Eloquent\Model
    {
        //
    }

    /**
     * App\Models\User
     *
     * @property \Illuminate\Support\Carbon|null $updated_at
     * @property \Illuminate\Support\Carbon|null $created_at
     * @property string|null $remember_token
     * @property int|null $instructor_id
     * @property string|null $email_verified_at
     * @property array|null $social_links
     * @property string|null $google_id
     * @property string|null $photo
     * @property integer|null $status
     * @property string $email
     * @property string $password
     * @property string $role
     * @property string $name
     * @property int $id
     * @property-read \App\Models\Instructor $instructor
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Laravel\Sanctum\PersonalAccessToken> $tokens
     * @property-read int|null $tokens_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
     * @property-read int|null $notifications_count
     * @property-read \Illuminate\Database\Eloquent\Collection<int, \Spatie\MediaLibrary\MediaCollections\Models\Media> $media
     * @property-read int|null $media_count
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRole($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereStatus($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePhoto($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereGoogleId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereSocialLinks($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereInstructorId($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User select(mixed $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User selectRaw(string $expression)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User fromRaw(string $expression, mixed $bindings)
     * @method static array createSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static array parseSub(mixed $query)
     * @method static mixed prependDatabaseNameIfCrossDatabaseQuery(mixed $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addSelect(mixed $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User distinct()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User from(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $table, string|null $as)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forceIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User ignoreIndex(string $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User join(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second, string $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second, string $type, bool $where)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User joinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinLateral(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User leftJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinWhere(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string $operator, \Illuminate\Contracts\Database\Query\Expression|string $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User rightJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as, \Closure|\Illuminate\Contracts\Database\Query\Expression|string $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoin(\Illuminate\Contracts\Database\Query\Expression|string $table, \Closure|\Illuminate\Contracts\Database\Query\Expression|string|null $first, string|null $operator, \Illuminate\Contracts\Database\Query\Expression|string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User crossJoinSub(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query, string $as)
     * @method static \Illuminate\Database\Query\JoinClause newJoinClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Query\JoinLateralClause newJoinLateralClause(string $type, \Illuminate\Contracts\Database\Query\Expression|string $table)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeWheres(array $wheres, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User where(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addArrayOfWheres(array $column, string $boolean, string $method)
     * @method static array prepareValueAndOperator(string $value, string $operator, bool $useDefault)
     * @method static bool invalidOperatorAndValue(string $operator, mixed $value)
     * @method static bool invalidOperator(string $operator)
     * @method static bool isBitwiseOperator(string $operator)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhere(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNot(\Closure|string|array|\Illuminate\Contracts\Database\Query\Expression $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second, string|null $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereColumn(\Illuminate\Contracts\Database\Query\Expression|string|array $first, string|null $operator, string|null $second)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRaw(\Illuminate\Contracts\Database\Query\Expression|string $sql, mixed $bindings, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRaw(string $sql, mixed $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotLike(\Illuminate\Contracts\Database\Query\Expression|string $column, string $value, bool $caseSensitive)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotIn(\Illuminate\Contracts\Database\Query\Expression|string $column, mixed $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereIntegerNotInRaw(string $column, \Illuminate\Contracts\Support\Arrayable|array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNull(string|array|\Illuminate\Contracts\Database\Query\Expression $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotNull(string|array|\Illuminate\Contracts\Database\Query\Expression $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetween(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotBetweenColumns(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereValueBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereValueNotBetween(mixed $value, array{: \Illuminate\Contracts\Database\Query\Expression|string, : \Illuminate\Contracts\Database\Query\Expression|string} $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotNull(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDate(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTime(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|null $operator, \DateTimeInterface|string|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereDay(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereMonth(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereYear(\Illuminate\Contracts\Database\Query\Expression|string $column, \DateTimeInterface|string|int|null $operator, \DateTimeInterface|string|int|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addDateBasedWhere(string $type, \Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNested(string $boolean)
     * @method static \Illuminate\Database\Query\Builder forNestedWhere()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedWhereQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereSub(\Illuminate\Contracts\Database\Query\Expression|string $column, string $operator, \Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNotExists(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $callback)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addWhereExistsQuery(string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRowValues(array $columns, string $operator, array $values, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereRowValues(array $columns, string $operator, array $values)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContains(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContains(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContain(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContain(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonOverlaps(string $column, mixed $value, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonOverlaps(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntOverlap(string $column, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntOverlap(string $column, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonContainsKey(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonContainsKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonDoesntContainKey(string $column, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonDoesntContainKey(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereJsonLength(string $column, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereJsonLength(string $column, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dynamicWhere(string $method, array $parameters)
     * @method static void addDynamic(string $segment, string $connector, array $parameters, int $index)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFullText(string|string[] $columns, string $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFullText(string|string[] $columns, string $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAll(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAny(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNone(\Illuminate\Contracts\Database\Query\Expression[]|\Closure[]|string[] $columns, mixed $operator, mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupBy(array|\Illuminate\Contracts\Database\Query\Expression|string ...$groups)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupByRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User having(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHaving(\Illuminate\Contracts\Database\Query\Expression|\Closure|string $column, \DateTimeInterface|string|int|float|null $operator, \Illuminate\Contracts\Database\Query\Expression|\DateTimeInterface|string|int|float|null $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNested(string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addNestedHavingQuery(\Illuminate\Database\Query\Builder $query, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNull(array|string $columns, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingNotNull(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingNotNull(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingBetween(string $column, string $boolean, bool $not)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User havingRaw(string $sql, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orHavingRaw(string $sql)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderBy(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User latest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User oldest(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User inRandomOrder(string|int $seed)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orderByRaw(string $sql, array $bindings)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User skip(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User offset(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User take(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User limit(int $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User groupLimit(int $value, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPage(int $page, int $perPage)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageBeforeId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User forPageAfterId(int $perPage, int|null $lastId, string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorder(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column, string $direction)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User reorderDesc(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Contracts\Database\Query\Expression|string|null $column)
     * @method static array removeExistingOrdersFor(string $column)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User union(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query, bool $all)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User unionAll(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $query)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lock(string|bool $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User lockForUpdate()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User sharedLock()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User beforeQuery()
     * @method static void applyBeforeQueryCallbacks()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User afterQuery()
     * @method static mixed applyAfterQueryCallbacks(mixed $result)
     * @method static string toSql()
     * @method static string toRawSql()
     * @method static User|null find(int|string $id, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static mixed findOr(mixed $id, callable|string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable|null $callback)
     * @method static mixed value(string $column)
     * @method static mixed rawValue()
     * @method static mixed soleValue(string $column)
     * @method static \Illuminate\Support\Collection<int,\stdClass> get(string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runSelect()
     * @method static \Illuminate\Support\Collection withoutGroupLimitKeys(\Illuminate\Support\Collection $items)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginate(int|\Closure $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page, \Closure|int|null $total)
     * @method static \Illuminate\Contracts\Pagination\Paginator simplePaginate(int $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $pageName, int|null $page)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator cursorPaginate(int|null $perPage, string|\Illuminate\Contracts\Database\Query\Expression|(string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static \Illuminate\Support\Collection ensureOrderForCursorPagination(bool $shouldReverse)
     * @method static int<0, max> getCountForPagination((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static array runPaginationCountQuery((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneForPaginationCount()
     * @method static (string|\Illuminate\Contracts\Database\Query\Expression)[] withoutSelectAliases((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns)
     * @method static \Illuminate\Support\LazyCollection<int,\stdClass> cursor()
     * @method static void enforceOrderBy()
     * @method static mixed pluck(\Illuminate\Contracts\Database\Query\Expression|string $column, string|null $key)
     * @method static string|null stripTableForPluck(string $column)
     * @method static \Illuminate\Support\Collection pluckFromObjectColumn(array $queryResult, string $column, string $key)
     * @method static \Illuminate\Support\Collection pluckFromArrayColumn(array $queryResult, string $column, string $key)
     * @method static string implode(string $column, string $glue)
     * @method static bool exists()
     * @method static bool doesntExist()
     * @method static mixed existsOr()
     * @method static mixed doesntExistOr()
     * @method static int<0, max> count(\Illuminate\Contracts\Database\Query\Expression|string $columns)
     * @method static mixed min(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed max(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed sum(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed avg(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed average(\Illuminate\Contracts\Database\Query\Expression|string $column)
     * @method static mixed aggregate(string $function, array $columns)
     * @method static float|int numericAggregate(string $function, array $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setAggregate(string $function, (\Illuminate\Contracts\Database\Query\Expression|string)[] $columns)
     * @method static \TResult onceWithColumns((string|\Illuminate\Contracts\Database\Query\Expression)[] $columns, callable $callback)
     * @method static bool insert()
     * @method static int<0, max> insertOrIgnore()
     * @method static int insertGetId(string|null $sequence)
     * @method static int insertUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int insertOrIgnoreUsing(\Closure|\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed>|string $query)
     * @method static int<0, max> update()
     * @method static int updateFrom()
     * @method static bool updateOrInsert()
     * @method static int upsert()
     * @method static int<0, max> increment(string $column, float|int $amount)
     * @method static int<0, max> incrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int<0, max> decrement(string $column, float|int $amount)
     * @method static int<0, max> decrementEach(array<string,float|int|numeric-string> $columns, array<string,mixed> $extra)
     * @method static int delete(mixed $id)
     * @method static void truncate()
     * @method static \Illuminate\Database\Query\Builder newQuery()
     * @method static \Illuminate\Database\Query\Builder forSubQuery()
     * @method static list<string> getColumns()
     * @method static \Illuminate\Contracts\Database\Query\Expression raw(mixed $value)
     * @method static \Illuminate\Support\Collection getUnionBuilders()
     * @method static mixed getLimit()
     * @method static mixed getOffset()
     * @method static list getBindings()
     * @method static array{select: list, from: list, join: list, where: list, groupBy: list, having: list, order: list, union: list, unionOrder: list} getRawBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User setBindings(list $bindings, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User addBinding(mixed $value, "select"|"from"|"join"|"where"|"groupBy"|"having"|"order"|"union"|"unionOrder" $type)
     * @method static mixed castBinding(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User mergeBindings(self $query)
     * @method static list cleanBindings(array $bindings)
     * @method static mixed flattenValue(mixed $value)
     * @method static string defaultKeyName()
     * @method static \Illuminate\Database\ConnectionInterface getConnection()
     * @method static \Illuminate\Database\Query\Processors\Processor getProcessor()
     * @method static \Illuminate\Database\Query\Grammars\Grammar getGrammar()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User useWritePdo()
     * @method static bool isQueryable(mixed $value)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User clone()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithout()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User cloneWithoutBindings()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dump(mixed ...$args)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User dumpRawSql()
     * @method static void dd()
     * @method static void ddRawSql()
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWherePast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrPast(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereNowOrFuture(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePastOrFuture(array|string $columns, string $operator, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereToday(array|string $columns, string $boolean)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereBeforeToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrBefore(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereAfterToday(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User orWhereTodayOrAfter(array|string $columns)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereTodayBeforeOrAfter(array|string $columns, string $operator, string $boolean)
     * @method static bool chunk(int $count, callable $callback)
     * @method static mixed chunkMap(callable $callback, int $count)
     * @method static bool each(callable $callback, int $count)
     * @method static bool chunkById(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool chunkByIdDesc(int $count, callable $callback, string|null $column, string|null $alias)
     * @method static bool orderedChunkById(int $count, callable $callback, string|null $column, string|null $alias, bool $descending)
     * @method static bool eachById(callable $callback, int $count, string|null $column, string|null $alias)
     * @method static mixed lazy(int $chunkSize)
     * @method static mixed lazyById(int $chunkSize, string|null $column, string|null $alias)
     * @method static mixed lazyByIdDesc(int $chunkSize, string|null $column, string|null $alias)
     * @method static \Illuminate\Support\LazyCollection orderedLazyById(int $chunkSize, string|null $column, string|null $alias, bool $descending)
     * @method static User|null first(array|string $columns)
     * @method static User firstOrFail(array|string $columns, string|null $message)
     * @method static User sole(array|string $columns)
     * @method static \Illuminate\Contracts\Pagination\CursorPaginator paginateUsingCursor(int $perPage, array|string $columns, string $cursorName, \Illuminate\Pagination\Cursor|string|null $cursor)
     * @method static string getOriginalColumnNameForCursorPagination(\Illuminate\Database\Query\Builder|\Illuminate\Database\Eloquent\Builder<mixed> $builder, string $parameter)
     * @method static \Illuminate\Pagination\LengthAwarePaginator paginator(\Illuminate\Support\Collection $items, int $total, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\Paginator simplePaginator(\Illuminate\Support\Collection $items, int $perPage, int $currentPage, array $options)
     * @method static \Illuminate\Pagination\CursorPaginator cursorPaginator(\Illuminate\Support\Collection $items, int $perPage, \Illuminate\Pagination\Cursor $cursor, array $options)
     * @method static \Illuminate\Database\Eloquent\Builder<User>|User tap(callable $callback)
     * @method static mixed pipe(callable $callback)
     * @method static mixed when(callable|\TWhenParameter|null $value, callable|null $callback, callable|null $default)
     * @method static mixed unless(callable|\TUnlessParameter|null $value, callable|null $callback, callable|null $default)
     * @method static \Illuminate\Support\Collection explain()
     * @method static mixed forwardCallTo(mixed $object, string $method, array $parameters)
     * @method static mixed forwardDecoratedCallTo(mixed $object, string $method, array $parameters)
     * @method static void throwBadMethodCallException(string $method)
     * @method static void macro(string $name, object|callable $macro)
     * @method static void mixin(object $mixin, bool $replace)
     * @method static bool hasMacro(string $name)
     * @method static void flushMacros()
     * @method static mixed macroCall(string $method, array $parameters)
     * @mixin \Illuminate\Database\Query\Builder
     */
    class User extends \Illuminate\Foundation\Auth\User
    {
        //
    }

}