<!DOCTYPE
   html
   PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
>
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
   <title>{{ config('app.name') }}</title>
   <meta
      name="viewport"
      content="width=device-width, initial-scale=1.0"
   />
   <meta
      http-equiv="Content-Type"
      content="text/html; charset=UTF-8"
   />
   <meta
      name="color-scheme"
      content="light"
   >
   <meta
      name="supported-color-schemes"
      content="light"
   >
   <style>
      @media only screen and (max-width: 600px) {
         .inner-body {
            width: 100% !important;
         }

         .footer {
            width: 100% !important;
         }
      }

      @media only screen and (max-width: 500px) {
         .button {
            width: 100% !important;
         }
      }

      :root {
         --rte-bg: #fff;
         --rte-fg: #1f2328;
         --rte-border: #d1d9e0;
         --rte-primary: #0969da;
         --rte-primary-fg: #fff;
         --rte-secondary: #f0f1f3;
         --rte-secondary-fg: #59636e;
         --rte-muted: #f6f8fa;
         --rte-muted-fg: #59636e;
         --rte-accent: #818b981f;
         --rte-accent-fg: #59636e;
         --rte-tooltip: #25292e;
         --rte-tooltip-fg: #f0f0f0;
         --rte-overlay: #32324d33;
         --rte-hljs-comment: #6a737d;
         --rte-hljs-keyword: #d73a49;
         --rte-hljs-entity: #6f42c1;
         --rte-hljs-function: #6f42c1;
         --rte-hljs-variable: #005cc5;
         --rte-hljs-constant: #005cc5;
         --rte-hljs-string: #032f62;
         --rte-hljs-regexp: #032f62;
         --rte-hljs-markup: #22863a;
         --rte-hljs-builtin: #e36209;
         --rte-hljs-inserted: #34d058;
         --rte-hljs-deleted: #b31d28;
         --rte-hljs-changed: #e36209;
         --rte-hljs-ignored: #f6f8fa;
         --rte-editor-font-size: 15px;
         --rte-editor-line-height: 1.5;
         --rte-editor-font: var(--font-sans);
         --rte-editor-code-font: var(--font-mono);
         --rte-editor-code-bg: #f6f8fa;
         --rte-editor-scrollbar: #00000040;
         --rte-editor-selection: #2383e247;
         --rte-radius: 0.5rem;
      }

      .dark {
         --rte-bg: #0d1017;
         --rte-fg: #f0f6fc;
         --rte-border: #3d444d;
         --rte-primary: #4493f8;
         --rte-tooltip: #3d444d;
         --rte-bubble: #151b23;
         --rte-overlay: #ffffff30;
         --rte-secondary: #2e373e;
         --rte-secondary-fg: #b1b8c0;
         --rte-muted: #1a2029;
         --rte-muted-fg: #b1b8c0;
         --rte-accent: #2d3440;
         --rte-accent-fg: #b1b8c0;
         --rte-hljs-comment: #8b949e;
         --rte-hljs-keyword: #ff7b72;
         --rte-hljs-entity: #d2a8ff;
         --rte-hljs-function: #d2a8ff;
         --rte-hljs-variable: #79c0ff;
         --rte-hljs-constant: #79c0ff;
         --rte-hljs-string: #a5d6ff;
         --rte-hljs-regexp: #a5d6ff;
         --rte-hljs-markup: #7ee787;
         --rte-hljs-builtin: #ffa657;
         --rte-hljs-inserted: #3fb950;
         --rte-hljs-deleted: #f85149;
         --rte-hljs-changed: #ffa657;
         --rte-hljs-ignored: #161b22;
         /* Editor settings */
         --rte-editor-code-bg: #1a2029;
         --rte-editor-scrollbar: #ffffff40;
         --rte-shadow-1: 0px 0px 0px 1px #3d444d, 0px 6px 12px -3px #01040966, 0px 6px 18px 0px #01040966;
         --rte-shadow-2:
            0px 0px 0px 1px #3d444d, 0px 8px 16px -4px #01040966, 0px 4px 32px -4px #01040966, 0px 24px 48px -12px #01040966,
            0px 48px 96px -24px #01040966;
         --rte-shadow-3: 0px 0px 0px 1px #3d444d, 0px 24px 48px 0px #010409;
      }

      .rte-button {
         all: unset;
         box-sizing: border-box;
         display: inline-flex;
         align-items: center;
         justify-content: center;
         font-weight: 500;
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         user-select: none;
         cursor: pointer;
         transition: all 0.15s ease-in;
         white-space: nowrap;
         width: auto;
         height: 2rem;
         padding-inline: 0.75rem;
         border: 1px solid transparent;
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-button:disabled {
         opacity: 0.5;
         pointer-events: none;
         cursor: not-allowed;
      }

      .rte-button__text {
         display: inline-flex;
         align-items: center;
         text-align: inherit;
         flex: 1 auto;
      }

      *+.rte-button__text {
         margin-left: 0.5rem;
      }

      .rte-button.rte-button--icon-only {
         padding: 0;
         aspect-ratio: 1/1;
      }

      .rte-button--primary {
         color: var(--rte-primary-fg);
         background-color: var(--rte-primary);
         border-color: var(--rte-primary);
      }

      .rte-button--primary:not(:disabled):hover {
         background-color: color-mix(in srgb, var(--rte-primary), #fff 15%);
      }

      .rte-button--secondary {
         color: var(--rte-secondary-fg);
         background-color: var(--rte-secondary);
         border-color: var(--rte-secondary);
      }

      .rte-button--secondary:not(:disabled):hover {
         background-color: color-mix(in srgb, var(--rte-secondary), #000 8%);
      }

      .rte-button--outline {
         background-color: var(--rte-bg, #ffffff);
         border-color: var(--rte-border);
      }

      .rte-button--outline:not(:disabled):hover {
         background-color: var(--rte-muted);
         color: var(--rte-muted-fg);
      }

      .rte-button--ghost {
         color: var(--rte-accent-fg);
      }

      .rte-button--ghost:not(:disabled):hover {
         background-color: var(--rte-accent);
         color: var(--rte-fg, #1f2328);
      }

      .rte-tooltip {
         z-index: 50;
         padding: 0.375rem 0.625rem;
         min-height: 1.75rem;
         text-wrap: nowrap;
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         background-color: var(--rte-tooltip);
         color: var(--rte-tooltip-fg);
         font-weight: 500;
         font-size: 0.75rem;
         line-height: 1rem;
         line-height: 1.5;
      }

      .rte-dropdown {
         z-index: 50;
         display: flex;
         flex-direction: column;
         gap: 0.25rem;
         padding: 0.375rem 0.375rem;
         background-color: var(--rte-bg, #ffffff);
         border-radius: var(--rte-radius, 0.5rem);
         box-shadow: var(--rte-shadow-1,
               0px 0px 0px 1px rgba(209, 217, 224, 0.5019607843),
               0px 6px 12px -3px rgba(37, 41, 46, 0.0392156863),
               0px 6px 18px 0px rgba(37, 41, 46, 0.1215686275));
      }

      .rte-dropdown__indicator {
         width: 1rem;
         display: flex;
         justify-content: center;
      }

      .rte-dropdown__item {
         position: relative;
         display: flex;
         gap: 0.5rem;
         align-items: center;
         padding: 0.375rem 0.5rem;
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         outline: none;
         color: var(--rte-fg, #1f2328);
         cursor: pointer;
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-dropdown__item:hover {
         background-color: var(--rte-accent);
      }

      .rte-dropdown__item[data-active],
      .rte-dropdown__item[data-active]:hover {
         color: var(--rte-primary);
         background-color: var(--rte-accent);
      }

      .rte-popover {
         z-index: 50;
         background-color: var(--rte-bg, #ffffff);
         padding: 0.25rem;
         border-radius: var(--rte-radius, 0.5rem);
         box-shadow: var(--rte-shadow-1,
               0px 0px 0px 1px rgba(209, 217, 224, 0.5019607843),
               0px 6px 12px -3px rgba(37, 41, 46, 0.0392156863),
               0px 6px 18px 0px rgba(37, 41, 46, 0.1215686275));
      }

      .rte-toolbar {
         display: flex;
         align-items: center;
         flex-direction: row;
         flex-wrap: wrap;
         row-gap: 0.375rem;
         column-gap: 0.25rem;
         padding: 0.375rem;
      }

      .rte-toolbar--vertical {
         flex-direction: column;
      }

      .rte-toolbar--dense {
         padding: 0.125rem;
      }

      .rte-toolbar__divider {
         border: 0px solid var(--rte-border);
         border-right-width: thin;
         width: 1px;
         height: 1.25rem;
         margin: 0 0.25rem;
         flex-shrink: 0;
      }

      .rte-toolbar__divider--horizontal {
         border: 0px solid var(--rte-border);
         border-bottom-width: thin;
         width: 100%;
         height: 1px;
         margin: 0.25rem 0;
      }

      .rte-input {
         display: flex;
         width: 100%;
         height: 2rem;
         padding: 0.375rem 0.625rem;
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         border: 1px solid var(--rte-border);
         background-color: var(--rte-muted);
         outline: transparent solid 2px;
         color: var(--rte-fg, #1f2328);
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-input::placeholder {
         color: var(--rte-muted-fg);
      }

      .rte-input:focus-visible {
         outline-color: var(--rte-primary);
      }

      .rte-label {
         font-size: 90%;
         display: inline-block;
         line-height: 1.25rem;
         margin-bottom: 0.5rem;
         color: var(--rte-muted-fg);
         font-weight: bold;
      }

      .rte-resizer {
         position: absolute;
         top: 0;
         left: 0;
         pointer-events: none;
         transition: none;
      }

      .rte-resizer__control {
         position: absolute;
         pointer-events: auto;
         background-color: var(--rte-primary);
         aspect-ratio: 1/1;
         border: 2px solid var(--rte-bg, #ffffff);
         transition: none;
      }

      .rte-dialog {
         position: fixed;
         inset: 0;
         background-color: var(--rte-overlay);
         backdrop-filter: blur(3px);
         display: flex;
         align-items: center;
         justify-content: center;
         z-index: 9999;
      }

      .rte-color__list {
         display: flex;
         flex-wrap: wrap;
         column-gap: 0.5rem;
         row-gap: 0.5rem;
      }

      .rte-color__btn {
         min-width: 1.25rem;
         height: 1.25rem;
         border: 1px solid var(--rte-border);
         border-radius: 4px;
         transition: all 0.3s cubic-bezier(0.075, 0.82, 0.165, 1);
         transform: scale(1);
      }

      .rte-color__btn:hover {
         transform: scale(1.2);
      }

      .rte-color__btn[data-active] {
         box-shadow:
            0 0 0 1px var(--rte-bg, #ffffff),
            0 0 0 3px var(--rte-primary);
      }

      .rte-cp {
         width: 260px;
         display: flex;
         flex-direction: column;
      }

      .rte-cp__tabs {
         display: flex;
         margin-inline: -0.25rem;
         margin-top: -0.25rem;
         border-bottom: 1px solid var(--rte-border);
      }

      .rte-cp__tab {
         width: 100%;
         font-size: 90%;
         position: relative;
      }

      .rte-cp__tab:first-child::after {
         content: '';
         position: absolute;
         right: -2px;
         width: 1px;
         height: 100%;
         border-left: 1px solid var(--rte-border);
      }

      .rte-cp__tab[data-active]::before {
         content: '';
         position: absolute;
         left: -0.125rem;
         bottom: -0.125rem;
         inset-inline: 0;
         height: 2px;
         background-color: var(--rte-primary);
      }

      .rte-cp__main {
         padding: 0 0.5rem;
         margin-block: 0.75rem;
      }

      .rte-cp__actions {
         padding: 0 0.5rem;
         margin-bottom: 0.5rem;
         margin-top: 0.125rem;
         display: flex;
         gap: 0.5rem;
      }

      .rte-cp-swatches,
      .rte-cp-custom {
         display: flex;
         flex-direction: column;
         gap: 0.625rem;
      }

      .rte-cp-custom__preview {
         display: flex;
         align-items: center;
         gap: 0.5rem;
      }

      .rte-tb__builder {
         font-size: 90%;
      }

      .rte-tb__grid {
         display: flex;
         flex-direction: column;
         gap: 0.375rem;
         padding: 0.5rem;
      }

      .rte-tb__row {
         display: flex;
         gap: 0.5rem;
      }

      .rte-tb__cell {
         width: 1rem;
         height: 1rem;
         background-color: var(--rte-accent);
         box-shadow: 0 0 0 1.5px var(--rte-border);
      }

      .rte-tb__cell--active {
         box-shadow: 0 0 0 1.5px var(--rte-primary);
      }

      .rte-editor {
         all: unset;
         display: flex;
         flex-direction: column;
         border: 1px solid var(--rte-border);
         border-radius: var(--rte-radius, 0.5rem);
         font-family: var(--rte-editor-font,
               -apple-system,
               BlinkMacSystemFont,
               Segoe UI,
               Roboto,
               Helvetica,
               Arial,
               sans-serif,
               Apple Color Emoji,
               Segoe UI Emoji);
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-editor--fullscreen {
         --rte-editor-max-height: auto;
         --rte-editor-min-height: auto;
         position: fixed;
         inset: 0;
         z-index: 50;
      }

      .rte-editor__content {
         flex: 1;
         position: relative;
         width: 100%;
         margin: 0 auto;
         font-size: var(--rte-editor-font-size, 1rem);
         line-height: var(--rte-editor-line-height, 1.75);
      }

      .rte-editor__container {
         cursor: text;
         display: flex;
         flex: 1;
         position: relative;
         padding-inline: 1rem;
         background-color: var(--rte-bg, #ffffff);
         color: var(--rte-fg, #1f2328);
         min-height: var(--rte-editor-min-height);
         max-height: var(--rte-editor-max-height);
         overflow: auto;
         scrollbar-width: thin;
         scrollbar-color: var(--rte-editor-scrollbar, rgba(0, 0, 0, 0.2509803922)) transparent;
      }

      .rte-editor__container:has(.cm-editor) {
         padding-inline: 1rem;
      }

      .rte-editor__container:has(.cm-focused),
      .rte-editor__container:has(.ProseMirror-focused) {
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         box-shadow: 0 0 0 2px var(--rte-primary);
      }

      .rte-menu-bar,
      .rte-status-bar {
         display: flex;
         align-items: center;
         min-height: 2.75rem;
         background-color: var(--rte-bg, #ffffff);
         padding: 0.125rem 0.125rem;
      }

      .rte-menu-bar {
         border-bottom: 1px solid var(--rte-border);
         border-top-left-radius: var(--rte-radius, 0.5rem);
         border-top-right-radius: var(--rte-radius, 0.5rem);
      }

      .rte-status-bar {
         border-top: 1px solid var(--rte-border);
         border-bottom-left-radius: var(--rte-radius, 0.5rem);
         border-bottom-right-radius: var(--rte-radius, 0.5rem);
      }

      .rte-status-bar .rte-counter {
         margin-left: auto;
         padding: 0.25rem 0.5rem;
         display: flex;
         align-items: center;
         gap: 0.75rem;
         font-weight: 500;
         color: var(--rte-muted-fg);
      }

      .rte-menu__button {
         position: relative;
         padding-inline: 0.5rem;
      }

      .rte-menu__button[data-active],
      .rte-menu__button[data-active]:hover {
         color: var(--rte-primary);
         background-color: var(--rte-accent);
      }

      .rte-menu__button:has(.rte-icon-arrow) {
         width: auto;
         padding-inline: 0.25rem;
      }

      .rte-menu__button:has(.rte-icon-arrow) .rte-button__text:first-child {
         margin-left: 0.25rem;
      }

      .rte-menu__button .rte-icon-arrow {
         display: flex;
         align-items: center;
         justify-content: center;
         margin-left: 0.125rem;
      }

      .rte-bubble-menu {
         border-radius: var(--rte-radius, 0.5rem);
         background-color: var(--rte-bubble, var(--rte-bg, #ffffff));
         box-shadow: var(--rte-shadow-2,
               0px 0px 0px 1px #d1d9e0,
               0px 8px 16px -4px rgba(37, 41, 46, 0.0784313725),
               0px 4px 32px -4px rgba(37, 41, 46, 0.0784313725),
               0px 24px 48px -12px rgba(37, 41, 46, 0.0784313725),
               0px 48px 96px -24px rgba(37, 41, 46, 0.0784313725));
      }

      .rte-link__form {
         width: 20rem;
         padding: 1rem;
      }

      .rte-link__label {
         font-weight: 600;
      }

      .rte-link__label:not(:first-child) {
         margin-top: 1rem;
      }

      .rte-link__actions {
         display: flex;
         justify-content: flex-end;
         align-items: center;
         gap: 0.5rem;
         margin-top: 1.125rem;
      }

      .rte-link__actions button {
         padding-inline: 1rem;
      }

      .rte-text-alternative__form {
         min-width: 22rem;
         display: flex;
         gap: 0.5rem;
         padding: 0.375rem 0.5rem;
      }

      .rte-text-alternative__form input {
         flex: 1;
         width: 100%;
      }

      .rte-heading-dropdown {
         min-width: 10rem;
      }

      .rte-heading-dropdown [data-heading='p'] {
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-heading-dropdown [data-heading='h1'] {
         font-size: 1.5rem;
         line-height: 2rem;
         font-weight: bold;
      }

      .rte-heading-dropdown [data-heading='h2'] {
         font-size: 1.25rem;
         line-height: 1.75rem;
         font-weight: bold;
      }

      .rte-heading-dropdown [data-heading='h3'] {
         font-size: 1.125rem;
         line-height: 1.75rem;
         font-weight: bold;
      }

      .rte-heading-dropdown [data-heading='h4'] {
         font-size: 1rem;
         line-height: 1.5rem;
         font-weight: bold;
      }

      .rte-code-dropdown {
         display: flex;
         flex-direction: column;
         gap: 0.5rem;
         padding: 0.5rem;
      }

      .rte-code-dropdown .code-search {
         height: 2.25rem;
      }

      .rte-code-dropdown .code-list {
         display: flex;
         flex-direction: column;
         gap: 0.25rem;
         overflow: auto;
         scrollbar-width: thin;
         scrollbar-color: var(--rte-editor-scrollbar, rgba(0, 0, 0, 0.2509803922)) transparent;
      }

      .rte-code-dropdown .code-item {
         position: relative;
         display: flex;
         align-items: center;
         gap: 0.5rem;
         padding: 0.375rem 0.375rem 0.375rem 1.75rem;
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         cursor: pointer;
         font-size: 0.875rem;
         line-height: 1.25rem;
      }

      .rte-code-dropdown .code-item:hover {
         background-color: var(--rte-accent);
      }

      .rte-code-dropdown .code-item__indicator {
         position: absolute;
         left: 0.375rem;
      }

      .ProseMirror-selectednode:has(iframe),
      img.ProseMirror-selectednode {
         box-shadow:
            0 0 0 3px var(--rte-bg, #ffffff),
            0 0 0 5px var(--rte-primary);
      }

      .ProseMirror {
         flex: 1;
         outline: none;
         width: 100%;
         white-space: pre-wrap;
         position: relative;
         padding-block: 1.25rem;
      }

      .ProseMirror[contenteditable='true'] .ProseMirror-selectednode:has(iframe),
      .ProseMirror[contenteditable='true'] img.ProseMirror-selectednode,
      .ProseMirror[contenteditable='true'] img:has(+ figcaption.ProseMirror-selectednode) {
         box-shadow:
            0 0 0 3px var(--rte-bg, #ffffff),
            0 0 0 5px var(--rte-primary);
      }

      .ProseMirror.resize-cursor {
         cursor: col-resize;
      }

      .ProseMirror>* {
         margin-top: 1.25rem;
      }

      .ProseMirror>*:first-child {
         margin-top: 0;
      }

      .ProseMirror [data-indent='1'] {
         text-indent: 1em;
      }

      .ProseMirror [data-indent='2'] {
         text-indent: 2em;
      }

      .ProseMirror [data-indent='3'] {
         text-indent: 3em;
      }

      .ProseMirror [data-indent='4'] {
         text-indent: 4em;
      }

      :where(.ProseMirror > p.is-editor-empty:first-child, figcaption.is-empty)::before {
         content: attr(data-placeholder);
         float: left;
         color: var(--rte-muted-fg);
         pointer-events: none;
         width: 100%;
         height: 0;
      }

      .ProseMirror ::selection,
      .ProseMirror .selection {
         background-color: var(--rte-editor-selection, tint-color(var(--rte-primary), 0.2));
      }

      .ProseMirror .selectedCell:after {
         z-index: 2;
         position: absolute;
         content: '';
         inset: 0;
         background-color: var(--rte-editor-selection, tint-color(var(--rte-primary), 0.2));
         pointer-events: none;
      }

      .ProseMirror h1,
      .ProseMirror h2,
      .ProseMirror h3,
      .ProseMirror h4 {
         font-weight: bold;
         margin-top: 1.25rem;
      }

      .ProseMirror h1 {
         font-size: 1.75em;
         margin-top: 1.75rem;
      }

      .ProseMirror h2 {
         font-size: 1.625em;
         margin-top: 1.75rem;
      }

      .ProseMirror h3 {
         font-size: 1.25em;
         margin-top: 1.5rem;
      }

      .ProseMirror h4 {
         font-size: 1em;
      }

      .ProseMirror p {
         font-size: 1em;
         line-height: 1.75;
      }

      .ProseMirror a {
         color: var(--rte-editor-link, var(--rte-primary));
         font-weight: 600;
      }

      .ProseMirror a:hover {
         text-decoration: underline;
      }

      .ProseMirror a:not([href]) {
         color: inherit;
         text-decoration: none;
         font-weight: normal;
      }

      .ProseMirror ul,
      .ProseMirror ol {
         padding-inline: 2rem;
      }

      .ProseMirror ul li,
      .ProseMirror ol li {
         margin-block: 0.375rem;
         padding-inline-start: 0.375rem;
      }

      .ProseMirror ul {
         list-style-type: disc;
      }

      .ProseMirror ol {
         list-style-type: decimal;
      }

      .ProseMirror blockquote {
         padding: 0.375rem 1.25rem;
         font-style: italic;
         border-left: 0.25rem solid var(--rte-border);
      }

      .ProseMirror img,
      .ProseMirror iframe,
      .ProseMirror video {
         display: block;
         max-width: 100%;
         height: auto;
         margin-inline: auto;
         cursor: default;
      }

      .ProseMirror iframe {
         width: 100%;
         margin: 0 auto;
         pointer-events: none;
         aspect-ratio: 16/9;
         position: relative;
      }

      .ProseMirror figure {
         cursor: default;
         user-select: none;
      }

      .ProseMirror figcaption {
         font-size: 90%;
         color: var(--rte-muted-fg);
         text-align: center;
         line-height: 1.4;
         cursor: text;
         padding: 0.5rem 1.5rem 0.25rem;
         margin-bottom: -0.25rem;
      }

      .ProseMirror code,
      .ProseMirror kbd,
      .ProseMirror samp,
      .ProseMirror pre {
         font-family: var(--rte-editor-code-font, ui-monospace, SFMono-Regular, SF Mono, Menlo, Consolas, Liberation Mono, monospace);
         font-feature-settings: normal;
         font-variation-settings: normal;
      }

      .ProseMirror code {
         background: var(--rte-editor-code-bg, #f6f8fa);
         border: 1px solid var(--rte-border);
         border-radius: calc(var(--rte-radius, 0.5rem) * 0.75);
         padding: 0.15rem 0.3rem;
         font-size: 90%;
      }

      .ProseMirror pre {
         white-space: pre !important;
         tab-size: 2;
         line-height: 1.55;
         padding: 0.75rem 1.25rem;
         background: var(--rte-editor-code-bg, #f6f8fa);
         border: 1px solid var(--rte-border);
         color: var(--rte-fg, #1f2328);
         overflow: auto;
         scrollbar-width: thin;
         scrollbar-color: var(--rte-editor-scrollbar, rgba(0, 0, 0, 0.2509803922)) transparent;
      }

      .ProseMirror pre code {
         background: transparent;
         padding: 0;
         border: none;
      }

      .ProseMirror .tableWrapper {
         overflow: auto;
         scrollbar-width: thin;
         scrollbar-color: var(--rte-editor-scrollbar, rgba(0, 0, 0, 0.2509803922)) transparent;
      }

      .ProseMirror table {
         border: 1px solid var(--rte-border);
         font-size: 90%;
         overflow: hidden;
         border-collapse: collapse;
         table-layout: fixed;
         margin-inline: auto;
      }

      .ProseMirror table th,
      .ProseMirror table td {
         border: 1px solid var(--rte-border);
         padding: 0.5rem 0.75rem;
         position: relative;
         vertical-align: top;
         text-align: left;
      }

      .ProseMirror table th {
         background-color: var(--rte-muted);
      }

      .ProseMirror table .column-resize-handle {
         background-color: var(--rte-primary);
         bottom: -2px;
         pointer-events: none;
         position: absolute;
         right: -1px;
         top: 0;
         width: 3.5px;
         z-index: 10;
      }

      /*!
      Theme: GitHub
      Description: Light theme as seen on github.com
      Author: github.com
      Maintainer: @Hirse
      Updated: 2021-05-15

      Outdated base version: https://github.com/primer/github-syntax-light
      Current colors taken from GitHub's CSS
      */
      .hljs-keyword,
      .hljs-meta .hljs-keyword,
      .hljs-template-tag,
      .hljs-template-variable,
      .hljs-type {
         color: var(--rte-hljs-keyword);
      }

      .hljs-title,
      .hljs-title.class_,
      .hljs-title.class_.inherited__,
      .hljs-title.function_ {
         color: var(--rte-hljs-function);
      }

      .hljs-attr,
      .hljs-attribute,
      .hljs-literal,
      .hljs-meta,
      .hljs-number,
      .hljs-operator,
      .hljs-variable,
      .hljs-selector-attr,
      .hljs-selector-id,
      .hljs-variable.language_ {
         color: var(--rte-hljs-variable);
      }

      .hljs-meta .hljs-string,
      .hljs-regexp,
      .hljs-string {
         color: var(--rte-hljs-string);
      }

      .hljs-built_in,
      .hljs-symbol,
      .hljs-params {
         color: var(--rte-hljs-builtin);
      }

      .hljs-code,
      .hljs-comment,
      .hljs-formula {
         color: var(--rte-hljs-comment);
      }

      .hljs-name,
      .hljs-quote,
      .hljs-selector-tag,
      .hljs-selector-pseudo {
         color: var(--rte-hljs-markup);
      }

      .hljs-addition {
         color: var(--rte-hljs-inserted);
         background-color: #1b4721;
      }

      .hljs-deletion {
         color: var(--rte-hljs-deleted);
         background-color: #78191b;
      }

      .hljs-changed {
         color: var(--rte-hljs-changed);
      }

      .hljs-section {
         color: var(--rte-hljs-constant);
         font-weight: bold;
      }

      .hljs-emphasis {
         color: var(--rte-hljs-fg);
         font-style: italic;
      }

      .hljs-strong {
         color: var(--rte-hljs-fg);
         font-weight: bold;
      }
   </style>

   {{ $head ?? '' }}
</head>

<body>
   <h1 style="font-size: 1.5em; font-weight: 600; margin-bottom: 1em;">
      Instructor Application Status Update
   </h1>

   @if ($status === 'approved')
      <h2 style="font-size: 1.25em; font-weight: 600; margin: 1.5em 0 1em;">
         🎉 Congratulations, {{ $user->name }}!
      </h2>


      <p style="margin-bottom: 1.5em;">
         Your instructor application has been approved! You can now create and manage courses on our platform.
      </p>


      @if (!empty($feedback))
         <div style="margin: 1.5em 0; padding: 1em; background-color: #f9fafb; border-radius: 0.5em;">
            <h3 style="font-weight: 600; margin-bottom: 0.5em;">Notes from our team:</h3>
            {!! $feedback !!}
         </div>
      @endif

      <a
         href="{{ route('dashboard') }}"
         style="display: inline-block; padding: 0.75em 1.5em; background-color: #0969da; color: #fff; border-radius: 0.5em; text-decoration: none; font-weight: 600;"
      >
         Go to Dashboard
      </a>
   @else
      <h2 style="font-size: 1.25em; font-weight: 600; margin: 1.5em 0 1em;">
         Application Status: {{ ucfirst($status) }}
      </h2>

      <p style="margin-bottom: 1em;">
         Your instructor application status has been updated to: <strong>{{ ucfirst($status) }}</strong>.
      </p>

      @if (!empty($feedback))
         <div style="margin: 1.5em 0; padding: 1em; background-color: #f9fafb; border-radius: 0.5em;">
            <h3 style="font-weight: 600; margin-bottom: 0.5em;">Reviewer Feedback:</h3>
            <div class="prose dark:prose-invert max-w-none py-6">
               <div class="tiptap ProseMirror !py-0">
                  {!! $feedback !!}
               </div>
            </div>
         </div>
      @endif

      @if ($status === 'rejected')
         <a
            href="{{ route('student.index', ['tab' => 'instructor']) }}"
            style="display: inline-block; padding: 0.75em 1.5em; background-color: #ef4444; color: #fff; border-radius: 0.5em; text-decoration: none; font-weight: 600;"
         >
            Re-apply
         </a>
      @endif
   @endif

   @if ($status === 'approved')
      <p style="margin: 1.5em 0;">
         Start creating your first course and share your knowledge with students around the world!
      </p>
   @endif

   <p style="margin: 1.5em 0; font-size: 0.875em; color: #4b5563;">
      If you have any questions, please don't hesitate to contact our support team.
   </p>

   <p style="margin: 2em 0 0;">
      Best regards,<br>
      {{ config('mail.from.name') }} Team
   </p>
</body>

</html>
