interface InputLang {
   // ==================================================
   // 01. Authentication & User Info
   // ==================================================
   email: string;
   new_email: string;
   your_email: string;
   remember_me: string;
   email_address: string;
   current_email: string;
   password: string;
   current_password: string;
   new_password: string;
   confirm_password: string;
   confirm_new_password: string;
   full_name: string;
   phone: string;
   username: string;
   profile_url: string;
   system_email: string;
   account_email: string;
   contact_email: string;
   from_address: string;
   from_name: string;

   // ==================================================
   // 02. General Content & Metadata
   // ==================================================
   url: string;
   name: string;
   title: string;
   status: string;
   icon: string;
   description: string;
   sub_title: string;
   thumbnail: string;
   banner: string;
   background_image: string;
   background_color: string;
   list_items: string;
   dropdown_items: string;
   action_type: string;
   active: string;
   tags: string;
   slug: string;
   url_slug: string;
   slogan: string;
   author: string;
   meta_title: string;
   meta_keywords: string;
   meta_description: string;
   og_title: string;
   og_description: string;
   allowed_file_types: string;

   // ==================================================
   // 03. Courses & Lessons
   // ==================================================
   student_name: string;
   course_name: string;
   completion_date: string;
   certificate_size: string;
   short_description: string;
   download_format: string;
   preview_video: string;
   preview_video_type: string;
   video_url: string;
   video_url_provider: string;
   select: string;
   select_provider: string;
   select_video: string;
   select_document: string;
   select_image: string;
   select_user: string;
   select_course: string;
   embed_source: string;
   duration: string;
   lesson_type: string;
   requirement: string;
   class_topic: string;
   start_date_time: string;
   summary: string;
   class_notes: string;
   enable_drip_content: string;
   course_level: string;
   course_instructor: string;
   made_in: string;
   pricing_type: string;
   price: string;
   expiry_period_type: string;
   expiry_date: string;
   expiry_duration: string;
   course_language: string;
   course_discount: string;
   enrollment_type: string;

   // ==================================================
   // 04. Exams, Questions & Feedback
   // ==================================================
   question_title: string;
   title_80_character: string;
   keywords: string;
   keywords_80_character: string;
   subtitle_80_character: string;
   question: string;
   answer: string;
   outcome: string;
   your_text: string;
   question_type: string;
   options: string;
   hours: string;
   minutes: string;
   seconds: string;
   total_mark: string;
   pass_mark: string;
   retake_attempts: string;
   section_title: string;
   feedback: string;
   review: string;
   rating: string;

   // ==================================================
   // 05. Jobs & Resume
   // ==================================================
   designation: string;
   resume: string;
   skills: string;
   skills_required: string;
   biography: string;
   job_title: string;
   job_description: string;
   job_type: string;
   work_type: string;
   experience_level: string;
   positions_available: string;
   location: string;
   application_deadline: string;
   salary_is_negotiable: string;
   minimum_salary: string;
   maximum_salary: string;
   currency: string;

   // ==================================================
   // 06. Payments, APIs & Keys
   // ==================================================
   subject: string;
   send_to: string;
   test_api_key: string;
   live_api_key: string;
   public_test_key: string;
   secret_test_key: string;
   public_live_key: string;
   secret_live_key: string;
   webhook_secret: string;
   sandbox_client_id: string;
   sandbox_secret_key: string;
   production_client_id: string;
   production_secret_key: string;
   test_public_key: string;
   test_secret_key: string;
   live_public_key: string;
   live_secret_key: string;
   client_id: string;
   secret_key: string;
   amount: string;
   account_id: string;
   client_secret: string;
   meeting_sdk_client_id: string;
   meeting_sdk_client_secret: string;
   do_you_want_use_web_sdk: string;
   mail_driver: string;
   host: string;
   port: string;
   encryption: string;
   storage_driver: string;
   access_key_id: string;
   secret_access_key: string;
   default_region: string;
   bucket_name: string;
   api_key: string;
   api_secret: string;
   store_id: string;
   store_password: string;

   // ==================================================
   // 07. Integrations & Configurations
   // ==================================================
   page_contents: string;
   google_client_id: string;
   google_client_secret: string;
   google_redirect_uri: string;
   merchant_id_public_key: string;
   merchant_key_secret_key: string;
   website: string;
   github: string;
   twitter: string;
   linkedin: string;
   facebook: string;
   website_name: string;
   website_title: string;
   logo_dark: string;
   logo_light: string;
   favicon: string;
   course_selling_currency: string;
   course_selling_tax: string;
   instructor_revenue: string;
   category: string;
   category_icon: string;
   category_status: string;
   coupon: string;
   select_zip_file: string;
   blog_banner: string;
   blog_thumbnail: string;
   select_option: string;
   mail_host: string;
   mail_port: string;
   mail_encryption: string;
   mail_username: string;
   mail_password: string;
   mail_from_address: string;
   mail_from_name: string;
   aws_access_key_id: string;
   aws_default_region: string;

   // ==================================================
   // 08. Authentication & User Info Placeholder
   // ==================================================
   email_placeholder: string;
   password_placeholder: string;
   confirm_password_placeholder: string;
   current_email_placeholder: string;
   new_email_placeholder: string;
   current_password_placeholder: string;
   new_password_placeholder: string;
   rewrite_password_placeholder: string;
   full_name_placeholder: string;
   your_name_placeholder: string;
   username_placeholder: string;
   phone_number_placeholder: string;
   contact_email_placeholder: string;
   system_type_placeholder: string;

   // ==================================================
   // 09. General Content & Metadata Placeholder
   // ==================================================
   name_placeholder: string;
   title_placeholder: string;
   slug_placeholder: string;
   url_placeholder: string;
   description_placeholder: string;
   icon_placeholder: string;
   status_placeholder: string;
   action_type_placeholder: string;
   image_url_placeholder: string;
   section_title_placeholder: string;
   content_here_placeholder: string;
   caption_placeholder: string;
   meta_title_placeholder: string;
   meta_keywords_placeholder: string;
   meta_description_placeholder: string;
   og_title_placeholder: string;
   og_description_placeholder: string;
   page_name_placeholder: string;
   page_slug_placeholder: string;
   page_title_placeholder: string;
   tags_placeholder: string;

   // ==================================================
   // 10. Courses & Lessons Placeholder
   // ==================================================
   course_name_placeholder: string;
   certificate_size_placeholder: string;
   course_title_placeholder: string;
   short_description_placeholder: string;
   category_placeholder: string;
   course_level_placeholder: string;
   course_language_placeholder: string;
   course_price_placeholder: string;
   discount_price_placeholder: string;
   video_url_placeholder: string;
   approval_status_placeholder: string;
   lesson_title_placeholder: string;
   provider_placeholder: string;
   type_video_url_placeholder: string;
   embed_source_placeholder: string;
   duration_placeholder: string;
   class_topic_placeholder: string;
   quiz_title_placeholder: string;
   instructor_placeholder: string;
   expiry_duration_placeholder: string;

   // ==================================================
   // 11. Exams, Questions & Feedback Placeholder
   // ==================================================
   question_placeholder: string;
   answer_placeholder: string;
   outcome_placeholder: string;
   question_type_placeholder: string;
   question_options_placeholder: string;
   answer_options_placeholder: string;
   hours_placeholder: string;
   minutes_placeholder: string;
   seconds_placeholder: string;
   experience_placeholder: string;
   your_subject_placeholder: string;
   review_placeholder: string;

   // ==================================================
   // 12. Jobs & Resume Placeholder
   // ==================================================
   biography_placeholder: string;
   designation_placeholder: string;
   skills_tag_placeholder: string;
   about_yourself_placeholder: string;
   job_title_placeholder: string;
   url_slug_placeholder: string;
   job_description_placeholder: string;
   location_placeholder: string;
   currency_placeholder: string;
   minimum_salary_placeholder: string;
   maximum_salary_placeholder: string;

   // ==================================================
   // 13. Payments, APIs & Keys Placeholder
   // ==================================================
   store_id_placeholder;
   store_password_placeholder;
   api_key_placeholder: string;
   api_secret_placeholder: string;
   test_api_key_placeholder: string;
   live_api_key_placeholder: string;
   mollie_test_api_key_placeholder: string;
   mollie_live_api_key_placeholder: string;
   sandbox_client_id_placeholder: string;
   production_client_id_placeholder: string;
   sandbox_secret_key_placeholder: string;
   production_secret_key_placeholder: string;
   test_public_key_placeholder: string;
   test_secret_key_placeholder: string;
   live_public_key_placeholder: string;
   live_secret_key_placeholder: string;
   webhook_secret_placeholder: string;
   your_amount_placeholder: string;
   paytm_merchant_id_placeholder: string;
   paytm_merchant_key_placeholder: string;
   razorpay_public_key_placeholder: string;
   razorpay_secret_key_placeholder: string;
   sslcommerz_public_key_placeholder: string;
   sslcommerz_secret_key_placeholder: string;
   coupon_placeholder: string;

   // ==================================================
   // 14. Integrations & Configurations Placeholder
   // ==================================================
   zoom_account_email_placeholder: string;
   zoom_account_id_placeholder: string;
   zoom_client_id_placeholder: string;
   zoom_client_secret_placeholder: string;
   meeting_sdk_client_id_placeholder: string;
   meeting_sdk_client_secret_placeholder: string;
   mail_driver_placeholder: string;
   smtp_example_placeholder: string;
   port_587_placeholder: string;
   encryption_placeholder: string;
   noreply_example_placeholder: string;
   your_company_name_placeholder: string;
   storage_driver_placeholder: string;
   access_key_id_placeholder: string;
   secret_access_key_placeholder: string;
   default_region_placeholder: string;
   bucket_name_placeholder: string;
   google_client_id_placeholder: string;
   google_client_secret_placeholder: string;
   google_redirect_url_placeholder: string;
   https_placeholder: string;
   website_name_placeholder: string;
   website_title_placeholder: string;
   keywords_placeholder: string;
   website_description_placeholder: string;
   author_name_placeholder: string;
   website_slogan_placeholder: string;
   system_email_placeholder: string;
   select_logo_placeholder: string;
   select_favicon_placeholder: string;
   select_banner_placeholder: string;
   select_user_placeholder: string;
   select_course_placeholder: string;
   selling_currency_placeholder: string;
   selling_tax_percentage_placeholder: string;
   revenue_percentage_placeholder: string;
   mail_host_placeholder: string;
   mail_port_placeholder: string;
   mail_username_placeholder: string;
   mail_password_placeholder: string;
   mail_from_address_placeholder: string;
   mail_from_name_placeholder: string;
   aws_access_key_id_placeholder: string;
   aws_default_region_placeholder: string;
}
