interface CommonLang {
   // Common Entities
   title: string;
   description: string;
   name: string;
   email: string;
   password: string;
   type: string;
   category: string;
   status: string;
   location: string;
   image: string;
   url: string;
   categories: string;
   students: string;
   courses: string;
   comments: string;
   comment: string;
   price: string;
   rating: string;
   instructor: string;
   role: string;
   action: string;
   actions: string;
   level: string;

   // Common Status
   active: string;
   inactive: string;
   published: string;
   draft: string;
   expired: string;
   pending: string;
   enabled: string;
   disabled: string;
   language: string;
   default: string;
   closed: string;
   paused: string;
   on: string;
   off: string;
   free: string;
   completed: string;

   // Common Actions & Account Management
   search: string;
   filter: string;
   create: string;
   update: string;
   edit: string;
   save: string;
   delete: string;
   cancel: string;
   submit: string;
   apply: string;
   view: string;
   preview: string;
   download: string;
   close: string;
   confirm: string;
   yes: string;
   no: string;
   ok: string;
   back: string;
   continue: string;
   skip: string;
   retry: string;
   refresh: string;
   reload: string;
   change_email: string;
   change_password: string;
   forget_password: string;

   // Common Status Messages & Time Terms
   loading: string;
   processing: string;
   saving: string;
   updating: string;
   deleting: string;
   uploading: string;
   searching: string;
   no_results_found: string;
   today: string;
   yesterday: string;
   ago: string;

   // Common Settings
   general_settings: string;
   email_settings: string;
   payment_settings: string;
   settings: string;

   // Common Error Messages
   file_too_large: string;
   invalid_file: string;
   required_field: string;

   // Common Navigation
   home: string;
   about: string;
   contact: string;
   help: string;
   support: string;
   dashboard: string;

   // Common Pagination
   page: string;
   of: string;
   first: string;
   previous: string;
   next: string;
   last: string;
   go_to_page: string;

   // Common Media Types
   video: string;
   audio: string;
   document: string;
   file: string;

   // Course Related
   free: string;
   courses: string;
   students: string;
   reviews: string;
   select_the_approval_status: string;
}
