import { routeLastSegment } from '@/lib/route';
import { Award, Book, Briefcase, CassetteTape, CreditCard, LayoutDashboard, Newspaper, Receipt, School, Settings, Users } from 'lucide-react';

const dashboardRoutes: DashboardRoute[] = [
   {
      title: 'Main Menu',
      slug: 'main-menu',
      pages: [
         {
            Icon: LayoutDashboard,
            name: 'Dashboard',
            path: route('dashboard'),
            slug: routeLastSegment(route('dashboard')),
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [],
         },
         {
            Icon: School,
            name: 'Courses',
            path: '',
            slug: 'courses',
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Categories',
                  path: route('categories.index'),
                  slug: routeLastSegment(route('categories.index')),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Manage Courses',
                  slug: routeLastSegment(route('courses.index')),
                  path: route('courses.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Create Course',
                  slug: routeLastSegment(route('courses.create')),
                  path: route('courses.create'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Course Coupons',
                  slug: routeLastSegment(route('course-coupons.index')),
                  path: route('course-coupons.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Book,
            name: 'Exams',
            path: '',
            slug: 'exams',
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Categories',
                  slug: routeLastSegment(route('exam-categories.index')),
                  path: route('exam-categories.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Manage Exams',
                  slug: routeLastSegment(route('exams.index')),
                  path: route('exams.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Create Exam',
                  slug: routeLastSegment(route('exams.create')),
                  path: route('exams.create'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Exam Coupons',
                  slug: routeLastSegment(route('exam-coupons.index')),
                  path: route('exam-coupons.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: CassetteTape,
            name: 'Enrollments',
            path: '',
            slug: 'enrollments',
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Course Enrollments',
                  slug: routeLastSegment(route('course-enrollments.index')),
                  path: route('course-enrollments.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Exam Enrollments',
                  slug: routeLastSegment(route('exam-enrollments.index')),
                  path: route('exam-enrollments.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Users,
            name: 'Instructors',
            path: '',
            slug: 'instructors',
            active: true,
            access: ['admin', 'collaborative'],
            children: [
               {
                  name: 'Manage Instructors',
                  slug: routeLastSegment(route('instructors.index')),
                  path: route('instructors.index'),
                  access: ['admin', 'collaborative'],
               },
               {
                  name: 'Create Instructor',
                  slug: routeLastSegment(route('instructors.create')),
                  path: route('instructors.create'),
                  access: ['admin', 'collaborative'],
               },
               {
                  name: 'Applications',
                  slug: routeLastSegment(route('instructors.applications')),
                  path: route('instructors.applications', {
                     status: 'pending',
                  }),
                  access: ['admin', 'collaborative'],
               },
            ],
         },
         {
            Icon: Receipt,
            name: 'Payouts',
            path: '',
            slug: 'payouts',
            active: true,
            access: ['instructor', 'collaborative'],
            children: [
               {
                  name: 'Withdraw',
                  slug: routeLastSegment(route('payouts.index')),
                  path: route('payouts.index'),
                  access: ['instructor', 'collaborative'],
               },
               {
                  name: 'Settings',
                  slug: routeLastSegment(route('payouts.settings.index')),
                  path: route('payouts.settings.index'),
                  access: ['instructor', 'collaborative'],
               },
            ],
         },
         {
            Icon: Receipt,
            name: 'Payout Report',
            path: '',
            slug: 'payouts',
            active: true,
            access: ['admin', 'collaborative'],
            children: [
               {
                  name: 'Payout Request',
                  slug: routeLastSegment(route('payouts.request.index')),
                  path: route('payouts.request.index'),
                  access: ['admin', 'collaborative'],
               },
               {
                  name: 'Payout History',
                  slug: routeLastSegment(route('payouts.history.index')),
                  path: route('payouts.history.index'),
                  access: ['admin', 'collaborative'],
               },
            ],
         },
         {
            Icon: CreditCard,
            name: 'Payment Report',
            path: '',
            slug: 'payment-reports',
            active: true,
            access: ['admin', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Online Payments',
                  slug: routeLastSegment(route('payment-reports.online.index')),
                  path: route('payment-reports.online.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Offline Payments',
                  slug: routeLastSegment(route('payment-reports.offline.index')),
                  path: route('payment-reports.offline.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Briefcase,
            name: 'Job Circulars',
            path: '',
            slug: 'job-circulars',
            active: true,
            access: ['admin', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'All Jobs',
                  slug: routeLastSegment(route('job-circulars.index')),
                  path: route('job-circulars.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Create Job',
                  slug: routeLastSegment(route('job-circulars.create')),
                  path: route('job-circulars.create'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Book,
            name: 'Blogs',
            path: '',
            slug: 'blogs',
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Categories',
                  slug: routeLastSegment(route('blogs.categories.index')),
                  path: route('blogs.categories.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Create Blog',
                  slug: routeLastSegment(route('blogs.create')),
                  path: route('blogs.create'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'Manage Blog',
                  slug: routeLastSegment(route('blogs.index')),
                  path: route('blogs.index'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Newspaper,
            name: 'Newsletters',
            path: route('newsletters.index'),
            slug: routeLastSegment(route('newsletters.index')),
            active: true,
            access: ['admin', 'collaborative', 'administrative'],
            children: [],
         },
         {
            Icon: Users,
            name: 'All Users',
            path: route('users.index'),
            slug: routeLastSegment(route('users.index')),
            active: true,
            access: ['admin', 'collaborative', 'administrative'],
            children: [],
         },
         {
            Icon: Award,
            name: 'Certificates',
            path: '',
            slug: 'certification',
            active: true,
            access: ['admin', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Certificate',
                  slug: routeLastSegment(route('certificate.templates.index')),
                  path: route('certificate.templates.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Marksheet',
                  slug: routeLastSegment(route('marksheet.templates.index')),
                  path: route('marksheet.templates.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
            ],
         },
         {
            Icon: Settings,
            name: 'Settings',
            path: '',
            slug: 'settings',
            active: true,
            access: ['admin', 'instructor', 'collaborative', 'administrative'],
            children: [
               {
                  name: 'Account',
                  slug: routeLastSegment(route('settings.account')),
                  path: route('settings.account'),
                  access: ['admin', 'instructor', 'collaborative', 'administrative'],
               },
               {
                  name: 'System',
                  slug: routeLastSegment(route('settings.system')),
                  path: route('settings.system'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Pages',
                  slug: routeLastSegment(route('settings.pages')),
                  path: route('settings.pages'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Storage',
                  slug: routeLastSegment(route('settings.storage')),
                  path: route('settings.storage'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Payment',
                  slug: routeLastSegment(route('settings.payment')),
                  path: route('settings.payment'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'SMTP',
                  slug: routeLastSegment(route('settings.smtp')),
                  path: route('settings.smtp'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Auth',
                  slug: routeLastSegment(route('settings.auth0')),
                  path: route('settings.auth0'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Live Class',
                  slug: routeLastSegment(route('settings.live-class')),
                  path: route('settings.live-class'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
               {
                  name: 'Translation',
                  slug: routeLastSegment(route('language.index')),
                  path: route('language.index'),
                  access: ['admin', 'collaborative', 'administrative'],
               },
            ],
         },
      ],
   },
];

export default dashboardRoutes;
