import { Breadcrumb, BreadcrumbItem, BreadcrumbLink, BreadcrumbList, BreadcrumbPage, BreadcrumbSeparator } from '@/components/ui/breadcrumb';
import { Link } from '@inertiajs/react';
import { Fragment } from 'react';

export function Breadcrumbs({ breadcrumbs }: { breadcrumbs: any[] }) {
   return (
      <>
         {breadcrumbs.length > 0 && (
            <Breadcrumb>
               <BreadcrumbList>
                  {breadcrumbs.map((item, index) => {
                     const isLast = index === breadcrumbs.length - 1;
                     return (
                        <Fragment key={`breadcrumbs-${index}`}>
                           <BreadcrumbItem>
                              {isLast ? (
                                 <BreadcrumbPage>{item.title}</BreadcrumbPage>
                              ) : (
                                 <BreadcrumbLink asChild>
                                    <Link href={item.href}>{item.title}</Link>
                                 </BreadcrumbLink>
                              )}
                           </BreadcrumbItem>
                           {!isLast && <BreadcrumbSeparator key={`separator-${index}`} />}
                        </Fragment>
                     );
                  })}
               </BreadcrumbList>
            </Breadcrumb>
         )}
      </>
   );
}
