import { jsxs, jsx } from "react/jsx-runtime";
import { B as Button } from "./button-CoRGprmX.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, f as DialogClose } from "./dialog-Bzzm0V8u.js";
import { c as cn } from "./utils-Dq7odfJT.js";
import { router } from "@inertiajs/react";
import { useState } from "react";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
const WarningModal = (props) => {
  const { title, method, routePath, actionComponent, children } = props;
  const [modal, setModal] = useState(false);
  const [loading, setLoading] = useState(false);
  const requestProcess = () => ({
    preserveScroll: true,
    onSuccess: () => {
      setModal(false);
    },
    onFinish: () => {
      setLoading(false);
    }
  });
  const deleteHandler = () => {
    setLoading(true);
    switch (method) {
      case "get":
        router.get(routePath, {}, requestProcess());
        break;
      case "post":
        router.post(routePath, {}, requestProcess());
        break;
    }
  };
  return /* @__PURE__ */ jsxs(Dialog, { open: modal, onOpenChange: !loading ? setModal : void 0, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: actionComponent }),
    /* @__PURE__ */ jsxs(DialogContent, { className: cn("px-6 py-8 sm:max-w-[425px]", title && children ? "space-y-4" : "space-y-8"), children: [
      title && /* @__PURE__ */ jsx("h6", { className: "text-destructive text-center text-xl", children: title }),
      children,
      /* @__PURE__ */ jsxs("div", { className: "mb-0 flex items-center justify-center gap-6", children: [
        /* @__PURE__ */ jsx(DialogClose, { children: /* @__PURE__ */ jsx(Button, { className: "text-destructive border-destructive border bg-transparent px-5 hover:bg-transparent", children: "Cancel" }) }),
        /* @__PURE__ */ jsx(LoadingButton, { type: "button", variant: "secondary", onClick: deleteHandler, loading, disabled: loading, children: "Submit" })
      ] })
    ] })
  ] });
};
export {
  WarningModal as W
};
