import { clsx } from "clsx";
import { twMerge } from "tailwind-merge";
const mollieCurrencies = [
  { label: "United Arab Emirates Dirham", value: "AED", symbol: "د.إ" },
  { label: "Australian Dollar", value: "AUD", symbol: "A$" },
  { label: "Bulgarian Lev", value: "BGN", symbol: "лв" },
  { label: "Brazilian Real", value: "BRL", symbol: "R$" },
  { label: "Canadian Dollar", value: "CAD", symbol: "C$" },
  { label: "Swiss Franc", value: "CHF", symbol: "CHF" },
  { label: "Czech Koruna", value: "CZK", symbol: "Kč" },
  { label: "Danish Krone", value: "DKK", symbol: "kr" },
  { label: "Euro", value: "EUR", symbol: "€" },
  { label: "British Pound", value: "GBP", symbol: "£" },
  { label: "Hong Kong Dollar", value: "HKD", symbol: "HK$" },
  { label: "Hungarian Forint", value: "HUF", symbol: "Ft" },
  { label: "Israeli Shekel", value: "ILS", symbol: "₪" },
  { label: "Icelandic Króna", value: "ISK", symbol: "kr" },
  { label: "Japanese Yen", value: "JPY", symbol: "¥" },
  { label: "Mexican Peso", value: "MXN", symbol: "$" },
  { label: "Malaysian Ringgit", value: "MYR", symbol: "RM" },
  { label: "Norwegian Krone", value: "NOK", symbol: "kr" },
  { label: "New Zealand Dollar", value: "NZD", symbol: "NZ$" },
  { label: "Philippine Peso", value: "PHP", symbol: "₱" },
  { label: "Polish Zloty", value: "PLN", symbol: "zł" },
  { label: "Romanian Leu", value: "RON", symbol: "lei" },
  { label: "Russian Ruble", value: "RUB", symbol: "₽" },
  { label: "Swedish Krona", value: "SEK", symbol: "kr" },
  { label: "Singapore Dollar", value: "SGD", symbol: "S$" },
  { label: "Thai Baht", value: "THB", symbol: "฿" },
  { label: "U.S. Dollar", value: "USD", symbol: "$" },
  { label: "Taiwan New Dollar", value: "TWD", symbol: "NT$" },
  { label: "South African Rand", value: "ZAR", symbol: "R" }
];
const paypalCurrencies = [
  { label: "Australian Dollar", value: "AUD", symbol: "A$" },
  { label: "Brazilian Real", value: "BRL", symbol: "R$" },
  { label: "Canadian Dollar", value: "CAD", symbol: "C$" },
  { label: "Chinese Yuan", value: "CNY", symbol: "¥" },
  { label: "Czech Koruna", value: "CZK", symbol: "Kč" },
  { label: "Danish Krone", value: "DKK", symbol: "kr" },
  { label: "Euro", value: "EUR", symbol: "€" },
  { label: "Hong Kong Dollar", value: "HKD", symbol: "HK$" },
  { label: "Hungarian Forint", value: "HUF", symbol: "Ft" },
  { label: "Israeli Shekel", value: "ILS", symbol: "₪" },
  { label: "Japanese Yen", value: "JPY", symbol: "¥" },
  { label: "Malaysian Ringgit", value: "MYR", symbol: "RM" },
  { label: "Mexican Peso", value: "MXN", symbol: "$" },
  { label: "Norwegian Krone", value: "NOK", symbol: "kr" },
  { label: "New Zealand Dollar", value: "NZD", symbol: "NZ$" },
  { label: "Philippine Peso", value: "PHP", symbol: "₱" },
  { label: "Polish Zloty", value: "PLN", symbol: "zł" },
  { label: "Pound Sterling", value: "GBP", symbol: "£" },
  { label: "Russian Ruble", value: "RUB", symbol: "₽" },
  { label: "Singapore Dollar", value: "SGD", symbol: "S$" },
  { label: "Swedish Krona", value: "SEK", symbol: "kr" },
  { label: "Swiss Franc", value: "CHF", symbol: "CHF" },
  { label: "Taiwan New Dollar", value: "TWD", symbol: "NT$" },
  { label: "Thai Baht", value: "THB", symbol: "฿" },
  { label: "U.S. Dollar", value: "USD", symbol: "$" }
];
const paystackCurrencies = [
  // { label: 'Nigerian Naira', value: 'NGN', symbol: '₦' },
  // { label: 'U.S. Dollar', value: 'USD', symbol: '$' },
  // { label: 'Ghanaian Cedi', value: 'GHS', symbol: '₵' },
  { label: "South African Rand", value: "ZAR", symbol: "R" }
  // { label: 'Kenyan Shilling', value: 'KES', symbol: 'KSh' },
  // { label: 'West African CFA Franc', value: 'XOF', symbol: 'CFA' },
];
const razorpayCurrency = [
  { label: "Indian Rupee", value: "INR", symbol: "₹" },
  { label: "United States Dollar", value: "USD", symbol: "$" },
  { label: "Euro", value: "EUR", symbol: "€" },
  { label: "British Pound Sterling", value: "GBP", symbol: "£" },
  { label: "Singapore Dollar", value: "SGD", symbol: "S$" },
  { label: "Australian Dollar", value: "AUD", symbol: "A$" },
  { label: "Canadian Dollar", value: "CAD", symbol: "C$" },
  { label: "Hong Kong Dollar", value: "HKD", symbol: "HK$" },
  { label: "Japanese Yen", value: "JPY", symbol: "¥" },
  { label: "Saudi Riyal", value: "SAR", symbol: "﷼" },
  { label: "UAE Dirham", value: "AED", symbol: "د.إ" },
  { label: "Kuwaiti Dinar", value: "KWD", symbol: "د.ك" },
  { label: "Bahraini Dinar", value: "BHD", symbol: ".د.ب" },
  { label: "Omani Rial", value: "OMR", symbol: "﷼" },
  { label: "Qatari Riyal", value: "QAR", symbol: "﷼" },
  { label: "New Zealand Dollar", value: "NZD", symbol: "NZ$" },
  { label: "Swiss Franc", value: "CHF", symbol: "CHF" },
  { label: "Chinese Yuan Renminbi", value: "CNY", symbol: "¥" },
  { label: "Malaysian Ringgit", value: "MYR", symbol: "RM" },
  { label: "Thai Baht", value: "THB", symbol: "฿" },
  { label: "South Korean Won", value: "KRW", symbol: "₩" },
  { label: "Indonesian Rupiah", value: "IDR", symbol: "Rp" },
  { label: "Philippine Peso", value: "PHP", symbol: "₱" },
  { label: "Vietnamese Dong", value: "VND", symbol: "₫" },
  { label: "Turkish Lira", value: "TRY", symbol: "₺" },
  { label: "South African Rand", value: "ZAR", symbol: "R" },
  { label: "Brazilian Real", value: "BRL", symbol: "R$" },
  { label: "Mexican Peso", value: "MXN", symbol: "$" },
  { label: "Argentine Peso", value: "ARS", symbol: "$" },
  { label: "Chilean Peso", value: "CLP", symbol: "$" },
  { label: "Colombian Peso", value: "COP", symbol: "$" },
  { label: "Peruvian Sol", value: "PEN", symbol: "S/" },
  { label: "Polish Zloty", value: "PLN", symbol: "zł" },
  { label: "Czech Koruna", value: "CZK", symbol: "Kč" },
  { label: "Hungarian Forint", value: "HUF", symbol: "Ft" },
  { label: "Romanian Leu", value: "RON", symbol: "lei" },
  { label: "Russian Ruble", value: "RUB", symbol: "₽" },
  { label: "Ukrainian Hryvnia", value: "UAH", symbol: "₴" },
  { label: "Israeli New Shekel", value: "ILS", symbol: "₪" },
  { label: "Egyptian Pound", value: "EGP", symbol: "£" },
  { label: "Nigerian Naira", value: "NGN", symbol: "₦" },
  { label: "Kenyan Shilling", value: "KES", symbol: "KSh" },
  { label: "Ghanaian Cedi", value: "GHS", symbol: "₵" },
  { label: "Moroccan Dirham", value: "MAD", symbol: "د.م." },
  { label: "Tanzanian Shilling", value: "TZS", symbol: "TSh" },
  { label: "Ugandan Shilling", value: "UGX", symbol: "USh" },
  { label: "Bangladeshi Taka", value: "BDT", symbol: "৳" },
  { label: "Pakistani Rupee", value: "PKR", symbol: "₨" },
  { label: "Sri Lankan Rupee", value: "LKR", symbol: "₨" },
  { label: "Nepalese Rupee", value: "NPR", symbol: "₨" },
  { label: "Maldivian Rufiyaa", value: "MVR", symbol: "Rf" },
  { label: "Bhutanese Ngultrum", value: "BTN", symbol: "Nu." },
  { label: "Afghan Afghani", value: "AFN", symbol: "؋" },
  { label: "Danish Krone", value: "DKK", symbol: "kr" },
  { label: "Norwegian Krone", value: "NOK", symbol: "kr" },
  { label: "Swedish Krona", value: "SEK", symbol: "kr" },
  { label: "Icelandic Króna", value: "ISK", symbol: "kr" },
  { label: "Croatian Kuna", value: "HRK", symbol: "kn" },
  { label: "Bulgarian Lev", value: "BGN", symbol: "лв" },
  { label: "Serbian Dinar", value: "RSD", symbol: "дин" },
  { label: "Macedonian Denar", value: "MKD", symbol: "ден" },
  { label: "Albanian Lek", value: "ALL", symbol: "L" },
  { label: "Bosnia-Herzegovina Convertible Mark", value: "BAM", symbol: "KM" },
  { label: "Jordanian Dinar", value: "JOD", symbol: "د.ا" },
  { label: "Lebanese Pound", value: "LBP", symbol: "ل.ل" },
  { label: "Iraqi Dinar", value: "IQD", symbol: "ع.د" },
  { label: "Yemeni Rial", value: "YER", symbol: "﷼" },
  { label: "Syrian Pound", value: "SYP", symbol: "£" },
  { label: "Iranian Rial", value: "IRR", symbol: "﷼" },
  { label: "Kazakhstani Tenge", value: "KZT", symbol: "₸" },
  { label: "Uzbekistani Som", value: "UZS", symbol: "so'm" },
  { label: "Turkmenistani Manat", value: "TMT", symbol: "T" },
  { label: "Azerbaijani Manat", value: "AZN", symbol: "₼" },
  { label: "Georgian Lari", value: "GEL", symbol: "₾" },
  { label: "Armenian Dram", value: "AMD", symbol: "֏" },
  { label: "Kyrgyzstani Som", value: "KGS", symbol: "сом" },
  { label: "Tajikistani Somoni", value: "TJS", symbol: "ЅМ" },
  { label: "Mongolian Tugrik", value: "MNT", symbol: "₮" },
  { label: "Myanmar Kyat", value: "MMK", symbol: "K" },
  { label: "Cambodian Riel", value: "KHR", symbol: "៛" },
  { label: "Lao Kip", value: "LAK", symbol: "₭" },
  { label: "Brunei Dollar", value: "BND", symbol: "B$" },
  { label: "Macanese Pataca", value: "MOP", symbol: "MOP$" },
  { label: "New Taiwan Dollar", value: "TWD", symbol: "NT$" },
  { label: "Fijian Dollar", value: "FJD", symbol: "FJ$" },
  { label: "Papua New Guinean Kina", value: "PGK", symbol: "K" },
  { label: "Tongan Paʻanga", value: "TOP", symbol: "T$" },
  { label: "Samoan Tala", value: "WST", symbol: "WS$" },
  { label: "Vanuatu Vatu", value: "VUV", symbol: "VT" },
  { label: "Solomon Islands Dollar", value: "SBD", symbol: "SI$" },
  { label: "Algerian Dinar", value: "DZD", symbol: "د.ج" },
  { label: "Tunisian Dinar", value: "TND", symbol: "د.ت" },
  { label: "Libyan Dinar", value: "LYD", symbol: "ل.د" },
  { label: "Sudanese Pound", value: "SDG", symbol: "ج.س." },
  { label: "Ethiopian Birr", value: "ETB", symbol: "Br" },
  { label: "Somali Shilling", value: "SOS", symbol: "S" },
  { label: "Djiboutian Franc", value: "DJF", symbol: "Fdj" },
  { label: "Eritrean Nakfa", value: "ERN", symbol: "Nfk" },
  { label: "Mauritanian Ouguiya", value: "MRU", symbol: "UM" },
  { label: "West African CFA Franc", value: "XOF", symbol: "CFA" },
  { label: "Central African CFA Franc", value: "XAF", symbol: "FCFA" },
  { label: "CFP Franc", value: "XPF", symbol: "₣" },
  { label: "Comorian Franc", value: "KMF", symbol: "CF" },
  { label: "Malagasy Ariary", value: "MGA", symbol: "Ar" },
  { label: "Mauritian Rupee", value: "MUR", symbol: "₨" },
  { label: "Seychellois Rupee", value: "SCR", symbol: "₨" },
  { label: "Rwandan Franc", value: "RWF", symbol: "FRw" },
  { label: "Burundian Franc", value: "BIF", symbol: "FBu" },
  { label: "Congolese Franc", value: "CDF", symbol: "FC" },
  { label: "Angolan Kwanza", value: "AOA", symbol: "Kz" },
  { label: "Zambian Kwacha", value: "ZMW", symbol: "ZK" },
  { label: "Malawian Kwacha", value: "MWK", symbol: "MK" },
  { label: "Mozambican Metical", value: "MZN", symbol: "MT" },
  { label: "Zimbabwean Dollar", value: "ZWL", symbol: "Z$" },
  { label: "Botswana Pula", value: "BWP", symbol: "P" },
  { label: "Namibian Dollar", value: "NAD", symbol: "$" },
  { label: "Swazi Lilangeni", value: "SZL", symbol: "E" },
  { label: "Lesotho Loti", value: "LSL", symbol: "L" },
  { label: "Gambian Dalasi", value: "GMD", symbol: "D" },
  { label: "Sierra Leonean Leone", value: "SLE", symbol: "Le" },
  { label: "Liberian Dollar", value: "LRD", symbol: "$" },
  { label: "Guinean Franc", value: "GNF", symbol: "FG" },
  { label: "Cape Verdean Escudo", value: "CVE", symbol: "Esc" },
  { label: "São Tomé and Príncipe Dobra", value: "STN", symbol: "Db" },
  { label: "Uruguayan Peso", value: "UYU", symbol: "$" },
  { label: "Paraguayan Guarani", value: "PYG", symbol: "₲" },
  { label: "Bolivian Boliviano", value: "BOB", symbol: "Bs" },
  { label: "Venezuelan Bolívar", value: "VES", symbol: "Bs" },
  { label: "Guyanese Dollar", value: "GYD", symbol: "G$" },
  { label: "Surinamese Dollar", value: "SRD", symbol: "$" },
  { label: "Belize Dollar", value: "BZD", symbol: "BZ$" },
  { label: "Costa Rican Colón", value: "CRC", symbol: "₡" },
  { label: "Guatemalan Quetzal", value: "GTQ", symbol: "Q" },
  { label: "Honduran Lempira", value: "HNL", symbol: "L" },
  { label: "Nicaraguan Córdoba", value: "NIO", symbol: "C$" },
  { label: "Panamanian Balboa", value: "PAB", symbol: "B/." },
  { label: "Salvadoran Colón", value: "SVC", symbol: "₡" },
  { label: "Jamaican Dollar", value: "JMD", symbol: "J$" },
  { label: "Trinidad and Tobago Dollar", value: "TTD", symbol: "TT$" },
  { label: "Barbadian Dollar", value: "BBD", symbol: "Bds$" },
  { label: "Bahamian Dollar", value: "BSD", symbol: "$" },
  { label: "East Caribbean Dollar", value: "XCD", symbol: "$" },
  { label: "Haitian Gourde", value: "HTG", symbol: "G" },
  { label: "Dominican Peso", value: "DOP", symbol: "RD$" },
  { label: "Cuban Peso", value: "CUP", symbol: "$" },
  { label: "Belarusian Ruble", value: "BYN", symbol: "Br" },
  { label: "Moldovan Leu", value: "MDL", symbol: "L" }
];
const sslcommerzCurrency = [
  { label: "Bangladeshi Taka", value: "BDT", symbol: "৳" },
  { label: "US Dollar", value: "USD", symbol: "$" },
  { label: "Euro", value: "EUR", symbol: "€" },
  { label: "British Pound", value: "GBP", symbol: "£" },
  { label: "Australian Dollar", value: "AUD", symbol: "A$" },
  { label: "Canadian Dollar", value: "CAD", symbol: "C$" }
];
const stripeCurrencies = [
  { label: "United Arab Emirates Dirham", value: "AED", symbol: "د.إ" },
  { label: "Afghan Afghani", value: "AFN", symbol: "؋" },
  { label: "Albanian Lek", value: "ALL", symbol: "L" },
  { label: "Armenian Dram", value: "AMD", symbol: "֏" },
  { label: "Netherlands Antillean Gulden", value: "ANG", symbol: "ƒ" },
  { label: "Angolan Kwanza", value: "AOA", symbol: "Kz" },
  { label: "Argentine Peso", value: "ARS", symbol: "$" },
  { label: "Australian Dollar", value: "AUD", symbol: "A$" },
  { label: "Aruban Florin", value: "AWG", symbol: "ƒ" },
  { label: "Azerbaijani Manat", value: "AZN", symbol: "₼" },
  { label: "Bosnia & Herzegovina Convertible Mark", value: "BAM", symbol: "KM" },
  { label: "Barbadian Dollar", value: "BBD", symbol: "Bds$" },
  { label: "Bangladeshi Taka", value: "BDT", symbol: "৳" },
  { label: "Bulgarian Lev", value: "BGN", symbol: "лв" },
  { label: "Bahraini Dinar", value: "BHD", symbol: ".د.ب" },
  { label: "Burundian Franc", value: "BIF", symbol: "FBu" },
  { label: "Bermudian Dollar", value: "BMD", symbol: "$" },
  { label: "Brunei Dollar", value: "BND", symbol: "B$" },
  { label: "Bolivian Boliviano", value: "BOB", symbol: "Bs" },
  { label: "Brazilian Real", value: "BRL", symbol: "R$" },
  { label: "Bahamian Dollar", value: "BSD", symbol: "$" },
  { label: "Bhutanese Ngultrum", value: "BTN", symbol: "Nu." },
  { label: "Botswana Pula", value: "BWP", symbol: "P" },
  { label: "Belarusian Ruble", value: "BYN", symbol: "Br" },
  { label: "Belize Dollar", value: "BZD", symbol: "BZ$" },
  { label: "Canadian Dollar", value: "CAD", symbol: "C$" },
  { label: "Congolese Franc", value: "CDF", symbol: "FC" },
  { label: "Swiss Franc", value: "CHF", symbol: "CHF" },
  { label: "Chilean Peso", value: "CLP", symbol: "$" },
  { label: "Chinese Renminbi Yuan", value: "CNY", symbol: "¥" },
  { label: "Colombian Peso", value: "COP", symbol: "$" },
  { label: "Costa Rican Colón", value: "CRC", symbol: "₡" },
  { label: "Cape Verdean Escudo", value: "CVE", symbol: "Esc" },
  { label: "Czech Koruna", value: "CZK", symbol: "Kč" },
  { label: "Djiboutian Franc", value: "DJF", symbol: "Fdj" },
  { label: "Danish Krone", value: "DKK", symbol: "kr" },
  { label: "Dominican Peso", value: "DOP", symbol: "RD$" },
  { label: "Algerian Dinar", value: "DZD", symbol: "د.ج" },
  { label: "Egyptian Pound", value: "EGP", symbol: "£" },
  { label: "Eritrean Nakfa", value: "ERN", symbol: "Nfk" },
  { label: "Ethiopian Birr", value: "ETB", symbol: "Br" },
  { label: "Euro", value: "EUR", symbol: "€" },
  { label: "Fijian Dollar", value: "FJD", symbol: "FJ$" },
  { label: "Falkland Islands Pound", value: "FKP", symbol: "£" },
  { label: "Faroese Króna", value: "FOK", symbol: "kr" },
  { label: "British Pound", value: "GBP", symbol: "£" },
  { label: "Georgian Lari", value: "GEL", symbol: "₾" },
  { label: "Ghanaian Cedi", value: "GHS", symbol: "₵" },
  { label: "Gibraltar Pound", value: "GIP", symbol: "£" },
  { label: "Gambian Dalasi", value: "GMD", symbol: "D" },
  { label: "Guinean Franc", value: "GNF", symbol: "FG" },
  { label: "Guatemalan Quetzal", value: "GTQ", symbol: "Q" },
  { label: "Guyanese Dollar", value: "GYD", symbol: "G$" },
  { label: "Hong Kong Dollar", value: "HKD", symbol: "HK$" },
  { label: "Honduran Lempira", value: "HNL", symbol: "L" },
  { label: "Croatian Kuna", value: "HRK", symbol: "kn" },
  { label: "Haitian Gourde", value: "HTG", symbol: "G" },
  { label: "Hungarian Forint", value: "HUF", symbol: "Ft" },
  { label: "Indonesian Rupiah", value: "IDR", symbol: "Rp" },
  { label: "Israeli New Sheqel", value: "ILS", symbol: "₪" },
  { label: "Indian Rupee", value: "INR", symbol: "₹" },
  { label: "Iraqi Dinar", value: "IQD", symbol: "ع.د" },
  { label: "Iranian Rial", value: "IRR", symbol: "﷼" },
  { label: "Icelandic Króna", value: "ISK", symbol: "kr" },
  { label: "Jamaican Dollar", value: "JMD", symbol: "J$" },
  { label: "Jordanian Dinar", value: "JOD", symbol: "د.ا" },
  { label: "Japanese Yen", value: "JPY", symbol: "¥" },
  { label: "Kenyan Shilling", value: "KES", symbol: "KSh" },
  { label: "Kyrgyzstani Som", value: "KGS", symbol: "сом" },
  { label: "Cambodian Riel", value: "KHR", symbol: "៛" },
  { label: "Comorian Franc", value: "KMF", symbol: "CF" },
  { label: "South Korean Won", value: "KRW", symbol: "₩" },
  { label: "Kuwaiti Dinar", value: "KWD", symbol: "د.ك" },
  { label: "Cayman Islands Dollar", value: "KYD", symbol: "$" },
  { label: "Kazakhstani Tenge", value: "KZT", symbol: "₸" },
  { label: "Lao Kip", value: "LAK", symbol: "₭" },
  { label: "Lebanese Pound", value: "LBP", symbol: "ل.ل" },
  { label: "Sri Lankan Rupee", value: "LKR", symbol: "₨" },
  { label: "Liberian Dollar", value: "LRD", symbol: "$" },
  { label: "Lesotho Loti", value: "LSL", symbol: "L" },
  { label: "Libyan Dinar", value: "LYD", symbol: "ل.د" },
  { label: "Moroccan Dirham", value: "MAD", symbol: "د.م." },
  { label: "Moldovan Leu", value: "MDL", symbol: "L" },
  { label: "Malagasy Ariary", value: "MGA", symbol: "Ar" },
  { label: "Macedonian Denar", value: "MKD", symbol: "ден" },
  { label: "Myanmar Kyat", value: "MMK", symbol: "K" },
  { label: "Mongolian Tögrög", value: "MNT", symbol: "₮" },
  { label: "Macanese Pataca", value: "MOP", symbol: "MOP$" },
  { label: "Mauritanian Ouguiya", value: "MRU", symbol: "UM" },
  { label: "Mauritian Rupee", value: "MUR", symbol: "₨" },
  { label: "Maldivian Rufiyaa", value: "MVR", symbol: "Rf" },
  { label: "Malawian Kwacha", value: "MWK", symbol: "MK" },
  { label: "Mexican Peso", value: "MXN", symbol: "$" },
  { label: "Malaysian Ringgit", value: "MYR", symbol: "RM" },
  { label: "Mozambican Metical", value: "MZN", symbol: "MT" },
  { label: "Namibian Dollar", value: "NAD", symbol: "$" },
  { label: "Nigerian Naira", value: "NGN", symbol: "₦" },
  { label: "Nicaraguan Córdoba", value: "NIO", symbol: "C$" },
  { label: "Norwegian Krone", value: "NOK", symbol: "kr" },
  { label: "Nepalese Rupee", value: "NPR", symbol: "₨" },
  { label: "New Zealand Dollar", value: "NZD", symbol: "NZ$" },
  { label: "Omani Rial", value: "OMR", symbol: "﷼" },
  { label: "Panamanian Balboa", value: "PAB", symbol: "B/." },
  { label: "Peruvian Sol", value: "PEN", symbol: "S/" },
  { label: "Papua New Guinean Kina", value: "PGK", symbol: "K" },
  { label: "Philippine Peso", value: "PHP", symbol: "₱" },
  { label: "Pakistani Rupee", value: "PKR", symbol: "₨" },
  { label: "Polish Złoty", value: "PLN", symbol: "zł" },
  { label: "Paraguayan Guaraní", value: "PYG", symbol: "₲" },
  { label: "Qatari Riyal", value: "QAR", symbol: "﷼" },
  { label: "Romanian Leu", value: "RON", symbol: "lei" },
  { label: "Serbian Dinar", value: "RSD", symbol: "дин" },
  { label: "Russian Ruble", value: "RUB", symbol: "₽" },
  { label: "Rwandan Franc", value: "RWF", symbol: "FRw" },
  { label: "Saudi Riyal", value: "SAR", symbol: "﷼" },
  { label: "Solomon Islands Dollar", value: "SBD", symbol: "SI$" },
  { label: "Seychellois Rupee", value: "SCR", symbol: "₨" },
  { label: "Sudanese Pound", value: "SDG", symbol: "ج.س." },
  { label: "Swedish Krona", value: "SEK", symbol: "kr" },
  { label: "Singapore Dollar", value: "SGD", symbol: "S$" },
  { label: "Saint Helena Pound", value: "SHP", symbol: "£" },
  { label: "Sierra Leonean Leone", value: "SLE", symbol: "Le" },
  { label: "Somali Shilling", value: "SOS", symbol: "S" },
  { label: "Surinamese Dollar", value: "SRD", symbol: "$" },
  { label: "South Sudanese Pound", value: "SSP", symbol: "£" },
  { label: "São Tomé and Príncipe Dobra", value: "STN", symbol: "Db" },
  { label: "Salvadoran Colón", value: "SVC", symbol: "₡" },
  { label: "Syrian Pound", value: "SYP", symbol: "£" },
  { label: "Swazi Lilangeni", value: "SZL", symbol: "E" },
  { label: "Thai Baht", value: "THB", symbol: "฿" },
  { label: "Tajikistani Somoni", value: "TJS", symbol: "ЅМ" },
  { label: "Turkmenistani Manat", value: "TMT", symbol: "T" },
  { label: "Tunisian Dinar", value: "TND", symbol: "د.ت" },
  { label: "Tongan Paʻanga", value: "TOP", symbol: "T$" },
  { label: "Turkish Lira", value: "TRY", symbol: "₺" },
  { label: "Trinidad and Tobago Dollar", value: "TTD", symbol: "TT$" },
  { label: "New Taiwan Dollar", value: "TWD", symbol: "NT$" },
  { label: "Tanzanian Shilling", value: "TZS", symbol: "TSh" },
  { label: "Ukrainian Hryvnia", value: "UAH", symbol: "₴" },
  { label: "Ugandan Shilling", value: "UGX", symbol: "USh" },
  { label: "United States Dollar", value: "USD", symbol: "$" },
  { label: "Uruguayan Peso", value: "UYU", symbol: "$" },
  { label: "Uzbekistani Som", value: "UZS", symbol: "so'm" },
  { label: "Venezuelan Bolívar", value: "VES", symbol: "Bs" },
  { label: "Vietnamese Đồng", value: "VND", symbol: "₫" },
  { label: "Vanuatu Vatu", value: "VUV", symbol: "VT" },
  { label: "Samoan Tala", value: "WST", symbol: "WS$" },
  { label: "Central African CFA Franc", value: "XAF", symbol: "FCFA" },
  { label: "East Caribbean Dollar", value: "XCD", symbol: "$" },
  { label: "West African CFA Franc", value: "XOF", symbol: "CFA" },
  { label: "CFP Franc", value: "XPF", symbol: "₣" },
  { label: "Yemeni Rial", value: "YER", symbol: "﷼" },
  { label: "South African Rand", value: "ZAR", symbol: "R" },
  { label: "Zambian Kwacha", value: "ZMW", symbol: "ZK" },
  { label: "Zimbabwean Dollar", value: "ZWL", symbol: "Z$" }
];
const currencies = Array.from(
  new Map(
    [...mollieCurrencies, ...paypalCurrencies, ...paystackCurrencies, ...razorpayCurrency, ...sslcommerzCurrency, ...stripeCurrencies].map(
      (currency) => [`${currency.value}-${currency.symbol}`, currency]
    )
  ).values()
);
function cn(...inputs) {
  return twMerge(clsx(inputs));
}
const getCourseDuration = (course, format = "hhmmss") => {
  const totalSeconds = course.sections.reduce((totalTime, section) => {
    return totalTime + section.section_lessons.reduce((sectionTime, lesson) => {
      const [hours2, minutes2, seconds2] = (lesson.duration || "00:00:00").split(":").map(Number);
      return sectionTime + (hours2 * 3600 + minutes2 * 60 + seconds2);
    }, 0);
  }, 0);
  const hours = Math.floor(totalSeconds / 3600);
  const minutes = Math.floor(totalSeconds % 3600 / 60);
  if (format === "readable") {
    if (hours > 0 && minutes > 0) {
      return `${hours}hr ${minutes}min`;
    } else if (hours > 0) {
      return `${hours}hr`;
    } else {
      return `${minutes}min`;
    }
  }
  const seconds = totalSeconds % 60;
  return `${hours.toString().padStart(2, "0")}:${minutes.toString().padStart(2, "0")}:${seconds.toString().padStart(2, "0")}`;
};
const getCompletedContents = (watchHistory) => {
  const completed = typeof watchHistory.completed_watching === "string" ? JSON.parse(watchHistory.completed_watching) : watchHistory.completed_watching || [];
  return completed;
};
const getCourseCompletion = (course, completed) => {
  const totalItems = course.sections.reduce((total, section) => total + section.section_lessons.length + section.section_quizzes.length, 0);
  const completedItems = course.sections.reduce((total, section) => {
    const completedLessons = section.section_lessons.filter(
      (lesson) => completed.some((item) => String(item.id) === String(lesson.id) && item.type === "lesson")
    ).length;
    const completedQuizzes = section.section_quizzes.filter(
      (quiz) => completed.some((item) => String(item.id) === String(quiz.id) && item.type === "quiz")
    ).length;
    return total + completedLessons + completedQuizzes;
  }, 0);
  const percentage = totalItems > 0 ? (completedItems / totalItems * 100).toFixed(2) : "0.00";
  return {
    percentage,
    totalContents: totalItems,
    completedContents: completedItems
  };
};
const getColorWithOpacity = (color, opacity = 0.1) => {
  if (color.startsWith("rgba(")) {
    const match = color.match(/rgba\((\d+),(\d+),(\d+),([^)]+)\)/);
    if (match) {
      const [, r, g, b] = match;
      return `rgba(${r},${g},${b},${opacity})`;
    }
  }
  if (color.startsWith("rgb(")) {
    const match = color.match(/rgb\((\d+),(\d+),(\d+)\)/);
    if (match) {
      const [, r, g, b] = match;
      return `rgba(${r},${g},${b},${opacity})`;
    }
  }
  if (color.startsWith("#")) {
    const hex = color.replace("#", "");
    const r = parseInt(hex.substr(0, 2), 16);
    const g = parseInt(hex.substr(2, 2), 16);
    const b = parseInt(hex.substr(4, 2), 16);
    return `rgba(${r},${g},${b},${opacity})`;
  }
  const namedColors = {
    red: "rgba(255,0,0,",
    green: "rgba(0,128,0,",
    blue: "rgba(0,0,255,",
    yellow: "rgba(255,255,0,",
    purple: "rgba(128,0,128,",
    orange: "rgba(255,165,0,",
    pink: "rgba(255,192,203,",
    black: "rgba(0,0,0,",
    white: "rgba(255,255,255,"
  };
  if (namedColors[color.toLowerCase()]) {
    return `${namedColors[color.toLowerCase()]}${opacity})`;
  }
  return color;
};
const systemCurrency = (currency) => {
  return currencies.find((item) => item.value == currency);
};
function getReadingTime(description) {
  const plainText = description.replace(/<[^>]*>/g, "");
  const wordCount = plainText.trim().split(/\s+/).length;
  const wordsPerMinute = 200;
  const minutes = Math.ceil(wordCount / wordsPerMinute);
  return `${minutes} min read`;
}
const generateSlug = (title) => {
  return title.toLowerCase().replace(/[^a-z0-9\s-]/g, "").replace(/\s+/g, "-").replace(/-+/g, "-").replace(/^-+|-+$/g, "");
};
export {
  getCourseCompletion as a,
  getReadingTime as b,
  cn as c,
  getCourseDuration as d,
  generateSlug as e,
  currencies as f,
  getCompletedContents as g,
  paystackCurrencies as h,
  sslcommerzCurrency as i,
  stripeCurrencies as j,
  getColorWithOpacity as k,
  mollieCurrencies as m,
  paypalCurrencies as p,
  razorpayCurrency as r,
  systemCurrency as s
};
