import { jsxs, jsx } from "react/jsx-runtime";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { router } from "@inertiajs/react";
import { HelpCircle, ListTodo, Settings, CircleDollarSign, BookText, FileText, FolderInput, FlaskConical } from "lucide-react";
import { nanoid } from "nanoid";
import ExamUpdateHeader from "./exam-update-header-Dgj8KkWr.js";
import Attempts from "./attempts-CYI4cvqN.js";
import Basic from "./basic-Dj-wKore.js";
import Info from "./info-BSa5Jlon.js";
import Media from "./media-CrXaBRut.js";
import Pricing from "./pricing-BJ9sz8io.js";
import Questions from "./questions-Bjl1N_lQ.js";
import Resources from "./resources-DMh8HzQD.js";
import SEO from "./seo-BkD1hwwB.js";
import ExamSettings from "./settings-RO75RfNc.js";
import "react";
import "@radix-ui/react-tabs";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./sidebar-4chFkdEZ.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./button-CoRGprmX.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./dialog-Bzzm0V8u.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "richtor";
/* empty css                 */
import "./table-filter-BKvPriu7.js";
import "./debounce-ZFxqVthq.js";
import "./table-page-size-CjbVFJnO.js";
import "./table-footer-Cfva3_5Y.js";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./card-DBOrqCcU.js";
import "./exam-attempt-review-Drprq_xh.js";
import "./question-status-icon-C8jXAMrK.js";
import "./badge-CnqJovSa.js";
import "./question-type-badge-Bj5qVf8w.js";
import "./input-BPdrsFAc.js";
import "./exam-attempt-table-columns-2K5KGBve.js";
import "./combobox-BCj7gyvQ.js";
import "cmdk";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./faq-form-QR9s5iFA.js";
import "./outcome-form-Dv-KYHfo.js";
import "./requirement-form-D6ROJQAf.js";
import "./checkbox-DmVJz5lb.js";
import "@radix-ui/react-checkbox";
import "./radio-group-B7ePM9gk.js";
import "@radix-ui/react-radio-group";
import "./course-durations-Cq7bB4fL.js";
import "./data-sort-modal-fNvcILsf.js";
import "nprogress";
import "./delete-modal-CTUf4WRn.js";
import "./question-dialog-Bazy9Pw5.js";
import "./fill-blank-form-0FvZb4Yi.js";
import "./listening-form-DbVmcbiB.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "axios";
import "./matching-form-2cmKOU2m.js";
import "./multiple-choice-form-DHNzVhQm.js";
import "./ordering-form-YwJ7QhBf.js";
import "./short-answer-form-BhdLxjts.js";
import "./resource-form-CCmTsKO6.js";
import "./file-metadata-CvVo69cP.js";
const Update = (props) => {
  const { tab, exam } = props;
  const tabs = [
    {
      id: nanoid(),
      name: "Questions",
      slug: "questions",
      Icon: HelpCircle,
      Component: Questions
    },
    {
      id: nanoid(),
      name: "Resources",
      slug: "resources",
      Icon: ListTodo,
      Component: Resources
    },
    {
      id: nanoid(),
      name: "Attempts",
      slug: "attempts",
      Icon: ListTodo,
      Component: Attempts
    },
    {
      id: nanoid(),
      name: "Basic",
      slug: "basic",
      Icon: Settings,
      Component: Basic
    },
    {
      id: nanoid(),
      name: "Pricing",
      slug: "pricing",
      Icon: CircleDollarSign,
      Component: Pricing
    },
    {
      id: nanoid(),
      name: "Settings",
      slug: "settings",
      Icon: BookText,
      Component: ExamSettings
    },
    {
      id: nanoid(),
      name: "Info",
      slug: "info",
      Icon: FileText,
      Component: Info
    },
    {
      id: nanoid(),
      name: "Media",
      slug: "media",
      Icon: FolderInput,
      Component: Media
    },
    {
      id: nanoid(),
      name: "SEO",
      slug: "seo",
      Icon: FlaskConical,
      Component: SEO
    }
  ];
  return /* @__PURE__ */ jsxs("section", { className: "space-y-8", children: [
    /* @__PURE__ */ jsx(ExamUpdateHeader, {}),
    /* @__PURE__ */ jsxs(Tabs, { value: tab ?? tabs[0].slug, className: "grid grid-rows-1 gap-5 md:grid-cols-4", children: [
      /* @__PURE__ */ jsx("div", { className: "col-span-full md:col-span-1", children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list space-y-1", children: tabs.map(({ id, name, slug, Icon }) => /* @__PURE__ */ jsxs(
        TabsTrigger,
        {
          value: slug,
          className: "horizontal-tabs-trigger",
          onClick: () => router.get(
            route("exams.edit", {
              exam: exam.id,
              tab: slug
            })
          ),
          children: [
            /* @__PURE__ */ jsx(Icon, { className: "h-4 w-4" }),
            /* @__PURE__ */ jsx("span", { children: name })
          ]
        },
        id
      )) }) }),
      /* @__PURE__ */ jsx("div", { className: "col-span-full md:col-span-3", children: tabs.map(({ id, slug, Component }) => /* @__PURE__ */ jsx(TabsContent, { value: slug, className: "m-0", children: /* @__PURE__ */ jsx(Component, {}) }, id)) })
    ] })
  ] });
};
Update.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Update as default
};
