import { jsxs, jsx } from "react/jsx-runtime";
import { C as Card } from "./card-DBOrqCcU.js";
import { g as getPageSection, S as Section } from "./section-DVceEJ6r.js";
import { usePage, Link } from "@inertiajs/react";
import "react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "lucide-react";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "lucide-react/dynamic";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
const TopInstructors = () => {
  const { props } = usePage();
  const { innerPage, customize, topInstructors } = props;
  const topInstructorsSection = getPageSection(innerPage, "top_instructors");
  return /* @__PURE__ */ jsxs(Section, { customize, pageSection: topInstructorsSection, containerClass: "py-[120px]", children: [
    /* @__PURE__ */ jsxs("div", { className: "relative z-10 mx-auto mb-8 max-w-lg text-center", children: [
      /* @__PURE__ */ jsx("h2", { className: "mb-2 text-2xl font-bold sm:text-[30px]", children: topInstructorsSection == null ? void 0 : topInstructorsSection.title }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: topInstructorsSection == null ? void 0 : topInstructorsSection.description })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "relative", children: [
      /* @__PURE__ */ jsx("div", { className: "relative z-10 grid grid-cols-1 gap-7 md:grid-cols-2 lg:grid-cols-4", children: topInstructors.map((instructor) => /* @__PURE__ */ jsxs(Card, { className: "!shadow-card-lg relative overflow-hidden rounded-2xl", children: [
        /* @__PURE__ */ jsx(Link, { href: route("instructors.show", instructor.id), children: /* @__PURE__ */ jsx("div", { className: "relative h-[300px] overflow-hidden", children: /* @__PURE__ */ jsx(
          "img",
          {
            className: "h-full w-full object-cover object-center",
            src: instructor.user.photo || "/assets/images/intro/default/instructors/instructor-1.png",
            alt: ""
          }
        ) }) }),
        /* @__PURE__ */ jsxs("div", { className: "space-y-1 py-4 text-center", children: [
          /* @__PURE__ */ jsx("p", { className: "font-semibold", children: instructor.user.name }),
          /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: instructor.designation })
        ] })
      ] }, instructor.id)) }),
      /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:top-1/2 after:left-1/2 after:h-[240px] after:w-[240px] after:-translate-x-1/2 after:-translate-y-1/2 after:rounded-full after:bg-[rgba(97,95,255,1))] after:blur-[250px] after:content-['']" })
    ] })
  ] });
};
export {
  TopInstructors as default
};
