import { jsx, jsxs } from "react/jsx-runtime";
import { R as Razorpay, S as SSLCommerz, P as Paystack, M as Mollie, a as Stripe, b as Paypal } from "./stripe-6pg2vgeM.js";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { g as getQueryParams } from "./route-DlE7FdTW.js";
import { usePage, router } from "@inertiajs/react";
import "./input-error-CBKwRgzN.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./loading-button-C9msud_X.js";
import "lucide-react";
import "react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./switch-BqKLcKEJ.js";
import "./switch-BZ5JBg1u.js";
import "@radix-ui/react-switch";
import "./card-DBOrqCcU.js";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./inertia-BtwbgBI3.js";
import "@radix-ui/react-tabs";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Settings = ({ instructor }) => {
  const page = usePage();
  const params = getQueryParams(page.url);
  const tabs = instructor.payout_methods.map((payment) => {
    let Component;
    switch (payment.sub_type) {
      case "paypal":
        Component = Paypal;
        break;
      case "stripe":
        Component = Stripe;
        break;
      case "mollie":
        Component = Mollie;
        break;
      case "paystack":
        Component = Paystack;
        break;
      case "sslcommerz":
        Component = SSLCommerz;
        break;
      case "razorpay":
        Component = Razorpay;
        break;
      default:
        Component = (props) => /* @__PURE__ */ jsx("div", { children: "No component found" });
        break;
    }
    return {
      ...payment,
      Component
    };
  });
  return /* @__PURE__ */ jsx("section", { className: "md:px-3", children: /* @__PURE__ */ jsxs(Tabs, { value: params["tab"] ?? tabs[0].sub_type, className: "grid grid-rows-1 gap-5 md:grid-cols-4", children: [
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list", children: tabs.map(({ id, title, sub_type }) => /* @__PURE__ */ jsx(
      TabsTrigger,
      {
        value: sub_type,
        className: "horizontal-tabs-trigger",
        onClick: () => router.get(
          route("payouts.settings.index", {
            tab: sub_type
          })
        ),
        children: title
      },
      id
    )) }) }),
    /* @__PURE__ */ jsx("div", { className: "md:col-span-3", children: tabs.map((payment) => /* @__PURE__ */ jsx(TabsContent, { value: payment.sub_type, className: "m-0", children: /* @__PURE__ */ jsx(payment.Component, { payment, routePath: route("payouts.settings.update") }) }, payment.id)) })
  ] }) });
};
Settings.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Settings as default
};
