import { jsxs, jsx } from "react/jsx-runtime";
import { C as ChunkedUploaderInput } from "./chunked-uploader-input-DSIqX-Yc.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader, d as DialogTitle } from "./dialog-Bzzm0V8u.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { S as ScrollArea } from "./scroll-area-Dgj2o23v.js";
import { S as Select, a as SelectTrigger, b as SelectValue, c as SelectContent, d as SelectItem } from "./select-DLRJE4Jo.js";
import { g as getFileMetadata } from "./file-metadata-CvVo69cP.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { usePage, useForm } from "@inertiajs/react";
import { useState, useEffect } from "react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "axios";
import "lucide-react";
import "sonner";
import "@radix-ui/react-dialog";
import "@radix-ui/react-label";
import "@radix-ui/react-scroll-area";
import "@radix-ui/react-select";
const ResourceForm = ({ title, handler, resource }) => {
  const [open, setOpen] = useState(false);
  const [isSubmit, setIsSubmit] = useState(false);
  const [isFileUploaded, setIsFileUploaded] = useState(false);
  const { exam, translate } = usePage().props;
  const { input, button } = translate;
  const { data, setData, post, put, reset, processing, errors, clearErrors } = useForm({
    title: resource ? resource.title : "",
    type: resource ? resource.type : "document",
    resource: resource ? resource.resource : "",
    resource_url: null,
    exam_id: exam.id
  });
  const handleSubmit = async (e) => {
    e.preventDefault();
    if (data.type === "link") {
      submitForm();
      return;
    }
    setIsSubmit(true);
  };
  const submitForm = () => {
    clearErrors();
    if (resource) {
      put(route("exam-resources.update", resource.id), {
        preserveScroll: true,
        onSuccess: () => {
          reset();
          setIsSubmit(false);
          setOpen(true);
        }
      });
    } else {
      post(route("exam-resources.store"), {
        preserveScroll: true,
        onSuccess: () => {
          reset();
          setIsSubmit(false);
          setOpen(true);
        }
      });
    }
  };
  useEffect(() => {
    if (data.resource_url && isFileUploaded) {
      submitForm();
      reset("resource_url");
      setIsFileUploaded(false);
    }
  }, [data.resource_url]);
  const resourceTypes = [
    { label: "Document", value: "document" },
    { label: "Image File", value: "image" },
    { label: "Video File", value: "video" },
    { label: "Zip/Archive", value: "zip" },
    { label: "External Link", value: "link" }
  ];
  return /* @__PURE__ */ jsxs(Dialog, { open, onOpenChange: setOpen, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { children: handler }),
    /* @__PURE__ */ jsx(DialogContent, { className: "p-0", children: /* @__PURE__ */ jsxs(ScrollArea, { className: "max-h-[90vh] p-6", children: [
      /* @__PURE__ */ jsx(DialogHeader, { className: "mb-6", children: /* @__PURE__ */ jsx(DialogTitle, { children: title }) }),
      /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: input.title }),
          /* @__PURE__ */ jsx(Input, { required: true, name: "title", value: data.title, placeholder: input.title, onChange: (e) => onHandleChange(e, setData) }),
          /* @__PURE__ */ jsx(InputError, { message: errors.title })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: "Resource Type" }),
          /* @__PURE__ */ jsxs(Select, { required: true, name: "type", value: data.type, onValueChange: (type) => setData("type", type), children: [
            /* @__PURE__ */ jsx(SelectTrigger, { className: "w-full", children: /* @__PURE__ */ jsx(SelectValue, { placeholder: input.select }) }),
            /* @__PURE__ */ jsx(SelectContent, { children: resourceTypes.map((type) => /* @__PURE__ */ jsx(SelectItem, { value: type.value, children: type.label }, type.value)) })
          ] })
        ] }),
        data.type === "link" ? /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: "Resource" }),
          /* @__PURE__ */ jsx(
            Input,
            {
              required: true,
              type: "url",
              name: "resource",
              value: data.resource,
              placeholder: input.url,
              onChange: (e) => onHandleChange(e, setData)
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.resource })
        ] }) : /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: "Resource" }),
          /* @__PURE__ */ jsx(
            ChunkedUploaderInput,
            {
              isSubmit,
              filetype: data.type,
              delayUpload: true,
              onFileSelected: (file) => {
                getFileMetadata(file).then((metadata) => {
                  setData("title", metadata.name);
                });
              },
              onFileUploaded: (fileData) => {
                setIsFileUploaded(true);
                setData("resource_url", fileData.file_url);
              },
              onError: (errors2) => {
                setIsSubmit(false);
              },
              onCancelUpload: () => {
                setIsSubmit(false);
              }
            }
          )
        ] }),
        /* @__PURE__ */ jsx(LoadingButton, { loading: processing || isSubmit, disabled: processing || isSubmit, children: resource ? "Update" : button.submit })
      ] })
    ] }) })
  ] });
};
export {
  ResourceForm as default
};
