import { jsx, jsxs } from "react/jsx-runtime";
import { C as Combobox } from "./combobox-BCj7gyvQ.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { A as Accordion, a as AccordionItem, c as AccordionContent } from "./accordion-DjZKTuzo.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { C as Checkbox } from "./checkbox-DmVJz5lb.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { R as RadioGroup, a as RadioGroupItem } from "./radio-group-B7ePM9gk.js";
import { c as courseDurations } from "./course-durations-Cq7bB4fL.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { usePage, useForm } from "@inertiajs/react";
import "./button-CoRGprmX.js";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "cmdk";
import "lucide-react";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "@radix-ui/react-accordion";
import "@radix-ui/react-checkbox";
import "@radix-ui/react-label";
import "@radix-ui/react-radio-group";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Pricing = () => {
  const { props } = usePage();
  const { translate } = props;
  const { dashboard, input, button } = translate;
  const { tab, prices, expiries, course } = props;
  const { data, setData, post, errors, processing } = useForm({
    tab,
    pricing_type: course.pricing_type || "",
    price: course.price || "",
    discount: Boolean(course.discount) || false,
    discount_price: course.discount_price || "",
    expiry_type: course.expiry_type || "",
    expiry_duration: course.expiry_duration || ""
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    post(route("courses.update", { id: course.id }));
  };
  return /* @__PURE__ */ jsx(Card, { className: "container p-4 sm:p-6", children: /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
    /* @__PURE__ */ jsxs(Accordion, { collapsible: true, type: "single", value: data.pricing_type, children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          input.pricing_type,
          " *"
        ] }),
        /* @__PURE__ */ jsx(
          RadioGroup,
          {
            defaultValue: data.pricing_type,
            className: "flex items-center space-x-4 pt-2 pb-1",
            onValueChange: (value) => setData("pricing_type", value),
            children: prices.map((price) => /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
              /* @__PURE__ */ jsx(RadioGroupItem, { className: "cursor-pointer", id: price, value: price }),
              /* @__PURE__ */ jsx(Label, { htmlFor: price, className: "capitalize", children: price })
            ] }, price))
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.pricing_type })
      ] }),
      /* @__PURE__ */ jsx(AccordionItem, { value: prices[1], className: "border-none", children: /* @__PURE__ */ jsxs(AccordionContent, { className: "space-y-4 p-0.5", children: [
        /* @__PURE__ */ jsxs("div", { className: "pt-3", children: [
          /* @__PURE__ */ jsxs(Label, { children: [
            dashboard.price,
            " *"
          ] }),
          /* @__PURE__ */ jsx(
            Input,
            {
              type: "number",
              name: "price",
              value: data.price,
              onChange: (e) => onHandleChange(e, setData),
              placeholder: input.course_price_placeholder
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.price })
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
          /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
            /* @__PURE__ */ jsx(
              Checkbox,
              {
                id: "discount",
                name: "discount",
                checked: data.discount,
                onCheckedChange: (checked) => {
                  setData("discount", checked);
                }
              }
            ),
            /* @__PURE__ */ jsx(Label, { htmlFor: "discount", children: dashboard.check_course_discount })
          ] }),
          data.discount && /* @__PURE__ */ jsxs("div", { children: [
            /* @__PURE__ */ jsx(
              Input,
              {
                type: "number",
                name: "discount_price",
                value: data.discount_price,
                onChange: (e) => onHandleChange(e, setData),
                placeholder: input.discount_price_placeholder
              }
            ),
            /* @__PURE__ */ jsx(InputError, { message: errors.discount_price })
          ] })
        ] })
      ] }) })
    ] }),
    /* @__PURE__ */ jsxs(Accordion, { collapsible: true, type: "single", value: data.expiry_type, children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Label, { children: "Expiry period type" }),
        /* @__PURE__ */ jsx(
          RadioGroup,
          {
            defaultValue: data.expiry_type,
            className: "flex items-center space-x-4 pt-2 pb-1",
            onValueChange: (value) => setData("expiry_type", value),
            children: expiries.map((expiry) => /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
              /* @__PURE__ */ jsx(RadioGroupItem, { className: "cursor-pointer", id: expiry, value: expiry }),
              /* @__PURE__ */ jsx(Label, { htmlFor: expiry, className: "capitalize", children: expiry.replace("_", " ") })
            ] }, expiry))
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.expiry_type })
      ] }),
      /* @__PURE__ */ jsx(AccordionItem, { value: expiries[1], className: "border-none", children: /* @__PURE__ */ jsx(AccordionContent, { className: "space-y-4 p-0.5", children: /* @__PURE__ */ jsxs("div", { className: "pt-3", children: [
        /* @__PURE__ */ jsx(Label, { children: input.expiry_duration }),
        /* @__PURE__ */ jsx(
          Combobox,
          {
            defaultValue: data.expiry_duration,
            data: courseDurations,
            placeholder: input.expiry_duration_placeholder || "Select duration",
            onSelect: (selected) => setData("expiry_duration", selected.value)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.expiry_duration })
      ] }) }) })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "mt-8", children: /* @__PURE__ */ jsx(LoadingButton, { loading: processing, children: button.save_changes }) })
  ] }) });
};
Pricing.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Pricing as default
};
