import { jsxs, jsx } from "react/jsx-runtime";
import { R as Razorpay, S as SSLCommerz, P as Paystack, M as Mollie, a as Stripe, b as Paypal } from "./stripe-6pg2vgeM.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { S as Switch } from "./switch-BqKLcKEJ.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { usePage, useForm, router } from "@inertiajs/react";
import { Editor } from "richtor";
/* empty css                 */
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { g as getQueryParams } from "./route-DlE7FdTW.js";
import "./input-BPdrsFAc.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./select-DLRJE4Jo.js";
import "react";
import "@radix-ui/react-select";
import "lucide-react";
import "./inertia-BtwbgBI3.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./switch-BZ5JBg1u.js";
import "@radix-ui/react-switch";
import "@radix-ui/react-label";
import "@radix-ui/react-tabs";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const Offline = ({ payment, routePath }) => {
  const { props } = usePage();
  const { translate } = props;
  const { button, common } = translate;
  const { data, setData, post, errors, processing } = useForm({
    ...payment.fields,
    type: "offline"
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    post(routePath);
  };
  return /* @__PURE__ */ jsxs(Card, { className: "p-4 sm:p-6", children: [
    /* @__PURE__ */ jsxs("div", { className: "mb-6 flex items-center justify-between", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("h2", { className: "text-xl font-semibold", children: "Offline Payment Settings" }),
        /* @__PURE__ */ jsx("p", { className: "text-gray-500", children: "Configure manual payment options for your students" })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center space-x-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "status", children: data.active ? common.enabled : common.disabled }),
        /* @__PURE__ */ jsx(Switch, { id: "status", checked: data.active, onCheckedChange: (checked) => setData("active", checked) })
      ] })
    ] }),
    /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-6", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsxs(Label, { children: [
          "Payment Instructions ",
          /* @__PURE__ */ jsx("span", { className: "font-light", children: "(for student)" })
        ] }),
        /* @__PURE__ */ jsx(
          Editor,
          {
            output: "html",
            placeholder: {
              paragraph: "Enter instructions here...",
              imageCaption: "Enter image caption here..."
            },
            contentMinHeight: 260,
            contentMaxHeight: 600,
            initialContent: data.payment_instructions,
            onContentChange: (value) => setData("payment_instructions", value)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.payment_instructions }),
        /* @__PURE__ */ jsx("p", { className: "mt-1 text-sm text-gray-500", children: "These instructions will be shown to students when they select offline payment" })
      ] }),
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(Label, { children: "Payment Details" }),
        /* @__PURE__ */ jsx(
          Editor,
          {
            output: "html",
            placeholder: {
              paragraph: "Enter payment details here...",
              imageCaption: "Enter image caption here..."
            },
            contentMinHeight: 260,
            contentMaxHeight: 600,
            initialContent: data.payment_details,
            onContentChange: (value) => setData("payment_details", value)
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.payment_details }),
        /* @__PURE__ */ jsx("p", { className: "mt-1 text-sm text-gray-500", children: "These payment/bank details will be displayed to students for making offline payments" })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "rounded-lg border border-yellow-200 bg-yellow-50 p-4", children: /* @__PURE__ */ jsxs("div", { className: "flex", children: [
        /* @__PURE__ */ jsx("svg", { className: "mr-2 h-5 w-5 shrink-0 text-yellow-600", fill: "currentColor", viewBox: "0 0 20 20", children: /* @__PURE__ */ jsx(
          "path",
          {
            fillRule: "evenodd",
            d: "M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z",
            clipRule: "evenodd"
          }
        ) }),
        /* @__PURE__ */ jsxs("div", { className: "text-sm text-yellow-800", children: [
          /* @__PURE__ */ jsx("p", { className: "mb-1 font-medium", children: "Important Notice" }),
          /* @__PURE__ */ jsx("p", { children: "Offline payments require manual verification. You will need to approve each payment in the Payment History section before the student can access the course." })
        ] })
      ] }) }),
      /* @__PURE__ */ jsx(LoadingButton, { loading: processing, type: "submit", className: "w-full", children: button.save_changes })
    ] })
  ] });
};
const Payment = ({ payments }) => {
  const page = usePage();
  const params = getQueryParams(page.url);
  const tabs = payments.map((payment) => {
    let Component;
    switch (payment.sub_type) {
      case "paypal":
        Component = Paypal;
        break;
      case "stripe":
        Component = Stripe;
        break;
      case "mollie":
        Component = Mollie;
        break;
      case "paystack":
        Component = Paystack;
        break;
      case "sslcommerz":
        Component = SSLCommerz;
        break;
      case "razorpay":
        Component = Razorpay;
        break;
      case "offline":
        Component = Offline;
        break;
      default:
        Component = ({ payment: payment2 }) => /* @__PURE__ */ jsx("div", { children: "No component found" });
        break;
    }
    return {
      ...payment,
      Component
    };
  });
  return /* @__PURE__ */ jsx("section", { className: "md:px-3", children: /* @__PURE__ */ jsxs(Tabs, { value: params["tab"] ?? tabs[0].sub_type, className: "grid grid-rows-1 gap-5 md:grid-cols-4", children: [
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list", children: tabs.map(({ id, title, sub_type }) => /* @__PURE__ */ jsx(
      TabsTrigger,
      {
        value: sub_type,
        className: "horizontal-tabs-trigger",
        onClick: () => router.get(
          route("settings.payment", {
            tab: sub_type
          })
        ),
        children: title
      },
      id
    )) }) }),
    /* @__PURE__ */ jsx("div", { className: "md:col-span-3", children: tabs.map((payment) => /* @__PURE__ */ jsx(TabsContent, { value: payment.sub_type, className: "m-0", children: /* @__PURE__ */ jsx(payment.Component, { payment, routePath: route("settings.payment.update", payment.id) }) }, payment.id)) })
  ] }) });
};
Payment.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Payment as default
};
