import { jsxs, jsx } from "react/jsx-runtime";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { usePage, useForm } from "@inertiajs/react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "lucide-react";
import "react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
const OutcomeForm = ({ outcome }) => {
  const { props } = usePage();
  const { translate } = props;
  const { input, button } = translate;
  const {
    data,
    setData,
    put,
    delete: destroy,
    errors,
    processing
  } = useForm({
    outcome: outcome ? outcome.outcome : ""
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    put(route("outcomes.update", { outcome: outcome.id }));
  };
  const handleDelete = () => {
    destroy(route("outcomes.destroy", { outcome: outcome.id }));
  };
  return /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-2", children: [
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(
        Input,
        {
          required: true,
          type: "text",
          name: "outcome",
          value: data.outcome || "",
          placeholder: input.outcome,
          onChange: (e) => onHandleChange(e, setData)
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.outcome })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "flex items-center justify-end gap-2", children: [
      /* @__PURE__ */ jsx(
        LoadingButton,
        {
          type: "button",
          variant: "outline",
          loading: processing,
          onClick: handleDelete,
          className: "h-7 w-full bg-red-50 text-xs hover:bg-red-100",
          children: button.remove
        }
      ),
      /* @__PURE__ */ jsx(LoadingButton, { variant: "secondary", className: "h-7 w-full text-xs", loading: processing, children: button.save })
    ] })
  ] });
};
export {
  OutcomeForm as default
};
