import { jsx, jsxs } from "react/jsx-runtime";
import { A as AppLogo } from "./app-logo-C1ut8-jl.js";
import { A as Appearance } from "./appearance-B5i6uI_j.js";
import { N as Notification } from "./notification-Bii6lhkq.js";
import { P as ProfileToggle } from "./profile-toggle-MdsR9VAt.js";
import { B as Button } from "./button-CoRGprmX.js";
import { u as useSidebar } from "./sidebar-4chFkdEZ.js";
import { u as useScreen } from "./use-screen-B7SDA5zE.js";
import { usePage, Link } from "@inertiajs/react";
import { Expand, Minimize, Menu } from "lucide-react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./dropdown-menu-DONmDWr6.js";
import "react";
import "@radix-ui/react-dropdown-menu";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "nanoid";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
const Navbar = () => {
  const { screen } = useScreen();
  const { open, toggleSidebar } = useSidebar();
  const { props } = usePage();
  const { translate } = props;
  const { button } = translate;
  props.auth.user;
  return /* @__PURE__ */ jsx("header", { className: "bg-primary dark:bg-primary-dark text-primary-foreground dark:text-primary sticky top-0 z-50 h-[60px]", children: /* @__PURE__ */ jsxs("div", { className: "flex h-full items-center justify-between gap-3 px-4 md:px-8", children: [
    /* @__PURE__ */ jsx(Link, { href: "/", children: /* @__PURE__ */ jsx(AppLogo, { theme: "light" }) }),
    /* @__PURE__ */ jsx("p", { className: "hidden font-semibold sm:block", children: props.course.title }),
    /* @__PURE__ */ jsxs("div", { className: "mr-0 flex items-center gap-2", children: [
      /* @__PURE__ */ jsx(Appearance, {}),
      /* @__PURE__ */ jsx(Notification, {}),
      screen > 768 && /* @__PURE__ */ jsx(
        Button,
        {
          size: "icon",
          variant: "secondary",
          onClick: () => toggleSidebar(),
          className: "border-secondary-light text-secondary-foreground hover:text-secondary-foreground rounded-full",
          children: open ? /* @__PURE__ */ jsx(Expand, {}) : /* @__PURE__ */ jsx(Minimize, {})
        }
      ),
      /* @__PURE__ */ jsx(ProfileToggle, {}),
      screen < 768 && /* @__PURE__ */ jsx(
        Button,
        {
          size: "icon",
          variant: "secondary",
          onClick: () => toggleSidebar(),
          className: "border-secondary-light text-secondary-foreground hover:text-secondary-foreground rounded-full",
          children: /* @__PURE__ */ jsx(Menu, {})
        }
      )
    ] })
  ] }) });
};
export {
  Navbar as default
};
