import { jsxs, Fragment, jsx } from "react/jsx-runtime";
import { T as Toaster } from "./sonner-0gqP4YyH.js";
import { usePage } from "@inertiajs/react";
import { useEffect } from "react";
import { toast } from "sonner";
const Main = ({ children }) => {
  const { props } = usePage();
  const { direction } = props;
  useEffect(() => {
    if (props.flash.error) {
      toast.error(props.flash.error);
    }
    if (props.flash.success || props.flash.warning) {
      toast.success(props.flash.success || props.flash.warning);
    }
  }, [props.flash]);
  useEffect(() => {
    document.documentElement.setAttribute("dir", direction);
  }, [direction]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(Toaster, {}),
    children
  ] });
};
export {
  Main as M
};
