import { jsxs, jsx } from "react/jsx-runtime";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { B as Button } from "./button-CoRGprmX.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { A as AuthLayout } from "./auth-layout-CPYrqQKs.js";
import { useForm, Head } from "@inertiajs/react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-label";
import "./app-logo-C1ut8-jl.js";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
const Index = () => {
  const { data, setData, post, processing, errors, reset } = useForm({
    email: "",
    password: ""
  });
  const submit = (e) => {
    e.preventDefault();
    post(route("system.verify"), {
      onFinish: () => reset("password")
    });
  };
  return /* @__PURE__ */ jsxs(AuthLayout, { title: "System Access", description: "Enter admin credentials to access system", children: [
    /* @__PURE__ */ jsx(Head, { title: "System Access" }),
    /* @__PURE__ */ jsx("form", { className: "flex flex-col gap-6", onSubmit: submit, children: /* @__PURE__ */ jsxs("div", { className: "grid gap-6", children: [
      /* @__PURE__ */ jsxs("div", { className: "grid gap-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "email", children: "Admin Email" }),
        /* @__PURE__ */ jsx(
          Input,
          {
            id: "email",
            type: "email",
            required: true,
            autoFocus: true,
            tabIndex: 1,
            autoComplete: "email",
            value: data.email,
            onChange: (e) => setData("email", e.target.value),
            placeholder: "admin@example.com"
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.email })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "grid gap-2", children: [
        /* @__PURE__ */ jsx(Label, { htmlFor: "password", children: "Password" }),
        /* @__PURE__ */ jsx(
          Input,
          {
            id: "password",
            type: "password",
            required: true,
            tabIndex: 2,
            autoComplete: "current-password",
            value: data.password,
            onChange: (e) => setData("password", e.target.value),
            placeholder: "Password"
          }
        ),
        /* @__PURE__ */ jsx(InputError, { message: errors.password })
      ] }),
      /* @__PURE__ */ jsx(Button, { type: "submit", className: "w-full", disabled: processing, children: processing ? "Verifying..." : "Verify Admin Access" })
    ] }) })
  ] });
};
export {
  Index as default
};
