import { jsxs, jsx } from "react/jsx-runtime";
import { D as DateTimePicker } from "./datetime-picker-vvicdyd7.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { B as Button } from "./button-CoRGprmX.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader, d as DialogTitle, f as DialogClose } from "./dialog-Bzzm0V8u.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { S as ScrollArea } from "./scroll-area-Dgj2o23v.js";
import { usePage, useForm } from "@inertiajs/react";
import { useState } from "react";
import { Editor } from "richtor";
/* empty css                 */
import "lucide-react";
import "react-day-picker";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./use-lang-44ndmTOc.js";
import "date-fns";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-dialog";
import "@radix-ui/react-label";
import "@radix-ui/react-scroll-area";
const LiveClassForm = ({ title, liveClass, handler, courseId }) => {
  const [open, setOpen] = useState(false);
  const { props } = usePage();
  const { translate } = props;
  const { dashboard, input, button } = translate;
  const { data, setData, post, put, reset, errors, processing } = useForm({
    course_id: courseId,
    class_topic: (liveClass == null ? void 0 : liveClass.class_topic) || "",
    class_note: (liveClass == null ? void 0 : liveClass.class_note) || "",
    class_date_and_time: (liveClass == null ? void 0 : liveClass.class_date_and_time) ? new Date(liveClass.class_date_and_time) : /* @__PURE__ */ new Date()
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    if (liveClass) {
      put(route("live-class.update", liveClass.id), {
        onSuccess: () => setOpen(false)
      });
    } else {
      post(route("live-class.store"), {
        onSuccess: () => {
          reset();
          setOpen(false);
        }
      });
    }
  };
  return /* @__PURE__ */ jsxs(Dialog, { open, onOpenChange: setOpen, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { children: handler }),
    /* @__PURE__ */ jsx(DialogContent, { className: "p-0", children: /* @__PURE__ */ jsxs(ScrollArea, { className: "max-h-[90vh] p-6", children: [
      /* @__PURE__ */ jsx(DialogHeader, { className: "mb-6", children: /* @__PURE__ */ jsx(DialogTitle, { children: title }) }),
      /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "space-y-4", children: [
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsxs(Label, { children: [
            dashboard.class_topic,
            " *"
          ] }),
          /* @__PURE__ */ jsx(
            Input,
            {
              type: "text",
              value: data.class_topic,
              onChange: (e) => setData("class_topic", e.target.value),
              placeholder: input.class_topic,
              required: true
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.class_topic })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsxs(Label, { children: [
            dashboard.start_date_time,
            " *"
          ] }),
          /* @__PURE__ */ jsx(DateTimePicker, { date: data.class_date_and_time, setDate: (date) => setData("class_date_and_time", date) }),
          /* @__PURE__ */ jsx(InputError, { message: errors.class_date_and_time })
        ] }),
        /* @__PURE__ */ jsxs("div", { children: [
          /* @__PURE__ */ jsx(Label, { children: dashboard.class_notes }),
          /* @__PURE__ */ jsx(
            Editor,
            {
              output: "html",
              placeholder: {
                paragraph: input.description,
                imageCaption: input.image_url_placeholder
              },
              contentMinHeight: 256,
              contentMaxHeight: 640,
              initialContent: data.class_note,
              onContentChange: (value) => setData((prev) => ({
                ...prev,
                class_note: value
              }))
            }
          ),
          /* @__PURE__ */ jsx(InputError, { message: errors.class_note })
        ] }),
        /* @__PURE__ */ jsxs("div", { className: "flex justify-end gap-3", children: [
          /* @__PURE__ */ jsx(DialogClose, { asChild: true, children: /* @__PURE__ */ jsx(Button, { type: "button", variant: "outline", children: button.cancel }) }),
          /* @__PURE__ */ jsx(Button, { type: "submit", disabled: processing, children: processing ? dashboard.scheduling : button.schedule_class })
        ] })
      ] })
    ] }) })
  ] });
};
export {
  LiveClassForm as default
};
