import { jsx, jsxs } from "react/jsx-runtime";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { S as ScrollArea } from "./scroll-area-Dgj2o23v.js";
import { S as Sheet, a as SheetTrigger, b as SheetContent } from "./sheet-BrIPI26w.js";
import { b as TabsContent } from "./tabs-CgNNKgka.js";
import { u as useScreen } from "./use-screen-B7SDA5zE.js";
import { L as LandingLayout } from "./landing-layout-CrHLE-uC.js";
import { usePage, useForm, Link } from "@inertiajs/react";
import { GraduationCap, FileQuestion, Heart, UserCircle, Settings, LoaderCircle, ListFilter } from "lucide-react";
import { useState, useMemo } from "react";
import TabLists from "./tab-lists-C_IvT-cN.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "@radix-ui/react-scroll-area";
import "@radix-ui/react-dialog";
import "@radix-ui/react-tabs";
import "./index-1bYjjcki.js";
import "./app-logo-C1ut8-jl.js";
import "lucide-react/dynamic";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./use-auth-8FvJer_G.js";
import "./appearance-B5i6uI_j.js";
import "./language-pQjimNcB.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./profile-toggle-MdsR9VAt.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "nanoid";
const Layout = ({ children, tab }) => {
  const { screen } = useScreen();
  const [open, setOpen] = useState(false);
  const { props } = usePage();
  const { translate, auth } = props;
  const { button } = translate;
  const tabs = useMemo(
    () => [
      {
        id: "courses",
        name: button.courses,
        slug: "courses",
        Icon: GraduationCap
      },
      {
        id: "exams",
        name: "Exams",
        slug: "exams",
        Icon: FileQuestion
      },
      {
        id: "wishlist",
        name: button.wishlist,
        slug: "wishlist",
        Icon: Heart
      },
      {
        id: "profile",
        name: button.profile,
        slug: "profile",
        Icon: UserCircle
      },
      {
        id: "settings",
        name: button.settings,
        slug: "settings",
        Icon: Settings
      }
    ],
    []
  );
  const { post, processing } = useForm({});
  const submit = (e) => {
    e.preventDefault();
    post(route("verification.send"));
  };
  return /* @__PURE__ */ jsx(LandingLayout, { customizable: false, language: true, children: /* @__PURE__ */ jsx("div", { className: "container py-6", children: /* @__PURE__ */ jsxs(Tabs, { value: tab, defaultValue: tabs[0].slug, className: "flex items-start gap-6 lg:gap-10", children: [
    screen > 768 && /* @__PURE__ */ jsx(Card, { className: "sticky top-24 w-full max-w-[270px] border-none p-4", children: /* @__PURE__ */ jsx(TabLists, { tabs }) }),
    /* @__PURE__ */ jsxs("div", { className: "w-full overflow-hidden", children: [
      !auth.user.email_verified_at && /* @__PURE__ */ jsxs("div", { className: "mb-6 rounded-md bg-red-50 p-6", children: [
        status === "verification-link-sent" ? /* @__PURE__ */ jsx("p", { className: "mb-4 text-center text-sm font-medium text-green-600", children: "A new verification link has been sent to the email address you provided during registration." }) : /* @__PURE__ */ jsx("p", { className: "mb-4 text-center text-sm font-medium text-red-500", children: "Your email is not verified yet. Please verify your email address by clicking on the link we just emailed to you." }),
        /* @__PURE__ */ jsxs("form", { onSubmit: submit, className: "flex items-center justify-center gap-4 text-center", children: [
          /* @__PURE__ */ jsxs(Button, { disabled: processing, variant: "secondary", children: [
            processing && /* @__PURE__ */ jsx(LoaderCircle, { className: "h-4 w-4 animate-spin" }),
            "Resend verification email"
          ] }),
          /* @__PURE__ */ jsx(Link, { href: route("logout"), method: "post", children: /* @__PURE__ */ jsx(Button, { children: "Log out" }) })
        ] })
      ] }),
      tabs.map(({ id, slug }) => /* @__PURE__ */ jsxs(TabsContent, { value: slug, className: "m-0", children: [
        screen < 768 && /* @__PURE__ */ jsxs(Sheet, { open, onOpenChange: setOpen, children: [
          /* @__PURE__ */ jsx(SheetTrigger, { asChild: true, children: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "outline", children: /* @__PURE__ */ jsx(ListFilter, { className: "h-5 w-5" }) }) }),
          /* @__PURE__ */ jsx(SheetContent, { side: "left", className: "border-border w-[230px] p-0", children: /* @__PURE__ */ jsx(ScrollArea, { className: "h-full w-full", children: /* @__PURE__ */ jsx(TabLists, { tabs }) }) })
        ] }),
        children
      ] }, id))
    ] })
  ] }) }) });
};
export {
  Layout as default
};
