import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { I as Index } from "./index-1bYjjcki.js";
import { M as Main } from "./main-BlfvuptM.js";
import { A as AppLogo } from "./app-logo-C1ut8-jl.js";
import { B as Button } from "./button-CoRGprmX.js";
import { D as DropdownMenu, a as DropdownMenuTrigger, b as DropdownMenuContent, d as DropdownMenuRadioGroup, c as DropdownMenuItem } from "./dropdown-menu-DONmDWr6.js";
import { S as ScrollArea } from "./scroll-area-Dgj2o23v.js";
import { u as useAuth } from "./use-auth-8FvJer_G.js";
import { u as useScreen } from "./use-screen-B7SDA5zE.js";
import { c as cn } from "./utils-Dq7odfJT.js";
import { usePage, Link } from "@inertiajs/react";
import { X, List, Menu, ChevronDown } from "lucide-react";
import { useState, useEffect, Fragment as Fragment$1 } from "react";
import { A as Appearance } from "./appearance-B5i6uI_j.js";
import { L as Language } from "./language-pQjimNcB.js";
import { N as Notification } from "./notification-Bii6lhkq.js";
import { P as ProfileToggle } from "./profile-toggle-MdsR9VAt.js";
const Actions = ({ language }) => {
  const { props } = usePage();
  const { navbar, translate, system } = props;
  const { isLoggedIn } = useAuth();
  const { screen } = useScreen();
  const [open, setOpen] = useState(false);
  const sortedItems = navbar.navbar_items.sort((a, b) => a.sort - b.sort);
  const actionElements = () => sortedItems.map((item) => {
    if (item.slug === "theme") {
      return /* @__PURE__ */ jsx(Appearance, {}, item.id);
    } else if (system.fields.language_selector && language && item.slug === "language") {
      return /* @__PURE__ */ jsx(Language, {}, item.id);
    } else if (isLoggedIn && item.slug === "notification") {
      return /* @__PURE__ */ jsx(Notification, {}, item.id);
    } else {
      return null;
    }
  });
  return /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
    screen > 768 ? /* @__PURE__ */ jsx("div", { className: "flex items-center gap-2", children: actionElements() }) : /* @__PURE__ */ jsxs(DropdownMenu, { open, onOpenChange: setOpen, children: [
      /* @__PURE__ */ jsx(DropdownMenuTrigger, { asChild: true, children: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "md:hidden", children: open ? /* @__PURE__ */ jsx(X, { className: "h-6 w-6" }) : /* @__PURE__ */ jsx(List, { className: "h-6 w-6" }) }) }),
      /* @__PURE__ */ jsx(DropdownMenuContent, { className: "w-12 min-w-10", children: /* @__PURE__ */ jsx(DropdownMenuRadioGroup, { value: "bottom", children: /* @__PURE__ */ jsx("div", { className: "flex flex-col items-center gap-2", children: actionElements() }) }) })
    ] }),
    isLoggedIn ? sortedItems.map((item) => {
      if (item.slug === "profile") {
        return /* @__PURE__ */ jsx(ProfileToggle, {}, item.id);
      } else {
        return null;
      }
    }) : /* @__PURE__ */ jsxs("div", { className: "hidden space-x-2 sm:block", children: [
      /* @__PURE__ */ jsx(Button, { asChild: true, variant: "outline", className: "", children: /* @__PURE__ */ jsx(Link, { href: route("register"), children: translate.button.sign_up }) }),
      /* @__PURE__ */ jsx(Button, { asChild: true, className: "", children: /* @__PURE__ */ jsx(Link, { href: route("login"), children: translate.button.log_in }) })
    ] })
  ] });
};
const Navbar = ({ language = false, heightCover = true, customizable = true }) => {
  const { props } = usePage();
  const { ziggy, navbar, translate } = props;
  const { isAdmin, isLoggedIn } = useAuth();
  const [isSticky, setIsSticky] = useState(false);
  const [isMenuOpen, setIsMenuOpen] = useState(false);
  const { screen } = useScreen();
  useEffect(() => {
    const handleScroll = () => {
      const scrollPosition = window.scrollY;
      if (scrollPosition > 100) {
        setIsSticky(true);
      } else {
        setIsSticky(false);
      }
    };
    window.addEventListener("scroll", handleScroll);
    return () => {
      window.removeEventListener("scroll", handleScroll);
    };
  }, []);
  const renderNavItems = (item) => {
    if (item.active) {
      switch (item.type) {
        case "url":
          return /* @__PURE__ */ jsx(Link, { href: item.value || "", className: "text-sm font-normal", children: item.title }, item.id);
        case "dropdown":
          return /* @__PURE__ */ jsxs(DropdownMenu, { children: [
            /* @__PURE__ */ jsxs(DropdownMenuTrigger, { className: "flex cursor-pointer items-center gap-1 text-sm", children: [
              item.title,
              /* @__PURE__ */ jsx(ChevronDown, { className: "ml-1 h-4 w-4" })
            ] }),
            /* @__PURE__ */ jsx(DropdownMenuContent, { align: "start", className: "min-w-20", children: item.items && Array.isArray(item.items) && item.items.map((subItem, idx) => /* @__PURE__ */ jsx(DropdownMenuItem, { asChild: true, className: "cursor-pointer px-5", children: /* @__PURE__ */ jsx(Link, { href: subItem.url || "", children: subItem.title }) }, idx)) })
          ] }, item.id);
        default:
          return null;
      }
    }
  };
  const sortedItems = navbar.navbar_items.sort((a, b) => a.sort - b.sort);
  const customizeLink = props.customize ? ziggy.location : "?customize=true";
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs("div", { className: cn("fixed top-0 z-30 w-full", isMenuOpen && "bg-background"), children: [
      /* @__PURE__ */ jsxs(
        "div",
        {
          className: cn(
            "container mt-0 flex h-[72px] items-center justify-between gap-1 !px-4 transition-all duration-200 md:gap-6",
            isSticky && "bg-background shadow-card mx-auto mt-4 h-16 w-full rounded-2xl md:!max-w-6xl",
            screen < 768 && "mt-0 h-[72px] rounded-none"
          ),
          children: [
            /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
              /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "md:hidden", onClick: () => setIsMenuOpen(!isMenuOpen), children: isMenuOpen ? /* @__PURE__ */ jsx(X, { className: "h-6 w-6" }) : /* @__PURE__ */ jsx(Menu, { className: "h-6 w-6" }) }),
              /* @__PURE__ */ jsx(Link, { href: "/", children: /* @__PURE__ */ jsx(AppLogo, {}) })
            ] }),
            /* @__PURE__ */ jsx("div", { className: "hidden gap-4 md:flex md:items-center", children: sortedItems.map((item) => /* @__PURE__ */ jsx(Fragment$1, { children: renderNavItems(item) }, item.id)) }),
            /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
              customizable && isAdmin && /* @__PURE__ */ jsx(Button, { asChild: true, variant: "outline", className: "hidden text-sm font-normal sm:block", children: /* @__PURE__ */ jsx(Link, { href: customizeLink, children: props.customize ? "Back" : "Customize" }) }),
              /* @__PURE__ */ jsx(Actions, { language })
            ] })
          ]
        }
      ),
      isMenuOpen && /* @__PURE__ */ jsx(ScrollArea, { className: "bg-background h-[calc(100vh-72px)] border-t md:hidden", children: /* @__PURE__ */ jsxs("div", { className: "flex flex-col space-y-4 px-6 py-4", children: [
        sortedItems.map((item) => /* @__PURE__ */ jsx(Fragment$1, { children: renderNavItems(item) }, item.id)),
        customizable && isAdmin && /* @__PURE__ */ jsx(Button, { asChild: true, variant: "outline", className: "text-sm font-normal", children: /* @__PURE__ */ jsx(Link, { href: customizeLink, children: props.customize ? "Back" : "Customize" }) }),
        !isLoggedIn && /* @__PURE__ */ jsxs("div", { className: "block space-y-2 sm:hidden", children: [
          /* @__PURE__ */ jsx(Button, { asChild: true, variant: "outline", className: "w-full rounded-sm shadow-none sm:px-5 md:h-10", children: /* @__PURE__ */ jsx(Link, { href: route("register"), children: translate.button.sign_up }) }),
          /* @__PURE__ */ jsx(Button, { asChild: true, className: "w-full rounded-sm shadow-none sm:px-5 md:h-10", children: /* @__PURE__ */ jsx(Link, { href: route("login"), children: translate.button.log_in }) })
        ] })
      ] }) })
    ] }),
    heightCover && /* @__PURE__ */ jsx("div", { className: "relative z-20 h-[72px] bg-transparent" })
  ] });
};
const LandingLayout = ({ children, language = false, navbarHeight = true, customizable }) => {
  return /* @__PURE__ */ jsx(Main, { children: /* @__PURE__ */ jsxs("div", { className: "flex min-h-screen flex-col justify-between overflow-x-hidden", children: [
    /* @__PURE__ */ jsxs("main", { children: [
      /* @__PURE__ */ jsx(Navbar, { heightCover: navbarHeight, customizable, language }),
      children
    ] }),
    /* @__PURE__ */ jsx(Index, {})
  ] }) });
};
export {
  LandingLayout as L
};
