import { jsxs, jsx } from "react/jsx-runtime";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { g as getPageSection, a as getPropertyArray, S as Section } from "./section-DVceEJ6r.js";
import { c as cn } from "./utils-Dq7odfJT.js";
import { usePage, Link } from "@inertiajs/react";
import { Pencil } from "lucide-react";
import { DynamicIcon } from "lucide-react/dynamic";
import InstructorSocials from "./instructor-socials-DvaquIWW.js";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "clsx";
import "tailwind-merge";
const Instructor = () => {
  const { props } = usePage();
  const { page, instructor, customize } = props;
  const instructorSection = getPageSection(page, "instructor");
  const oddElements = getPropertyArray(instructorSection).filter((_, index) => index % 2 === 0);
  const evenElements = getPropertyArray(instructorSection).filter((_, index) => index % 2 !== 0);
  return /* @__PURE__ */ jsxs(Section, { customize, pageSection: instructorSection, containerClass: "py-20", contentClass: "relative", children: [
    /* @__PURE__ */ jsxs("div", { className: "relative z-10 mx-auto mb-10 w-full text-center md:max-w-lg", children: [
      /* @__PURE__ */ jsx("p", { className: "text-secondary-foreground mb-1 font-medium", children: instructorSection == null ? void 0 : instructorSection.title }),
      /* @__PURE__ */ jsx("h2", { className: "mb-4 text-2xl font-bold sm:text-3xl", children: instructorSection == null ? void 0 : instructorSection.sub_title }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground", children: instructorSection == null ? void 0 : instructorSection.description })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "relative z-10 mx-auto grid w-full max-w-[964px] grid-cols-1 gap-8 md:grid-cols-3", children: [
      /* @__PURE__ */ jsx("div", { className: "space-y-12", children: oddElements == null ? void 0 : oddElements.map((item, index) => /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "bg-background shadow-card-md h-10 w-10 rounded p-2", children: /* @__PURE__ */ jsx(DynamicIcon, { name: item.icon, className: "text-secondary-foreground h-6 w-6" }) }),
        /* @__PURE__ */ jsx("h3", { className: "pt-4 pb-2 font-semibold", children: item.title }),
        /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: item.description })
      ] }, index)) }),
      /* @__PURE__ */ jsxs(Card, { className: "!shadow-card-hover space-y-6 p-5", children: [
        /* @__PURE__ */ jsx(
          "img",
          {
            className: "h-[190px] w-full rounded-lg object-cover object-top",
            src: (instructorSection == null ? void 0 : instructorSection.thumbnail) || "/assets/images/blank-image.jpg",
            alt: instructor ? instructor.user.name : ""
          }
        ),
        instructor && /* @__PURE__ */ jsxs("div", { className: cn("space-y-6", customize && "section-edit"), children: [
          customize && /* @__PURE__ */ jsx(Button, { asChild: true, size: "icon", variant: "secondary", className: "absolute top-3 right-3 z-20", children: /* @__PURE__ */ jsx(Link, { href: route("settings.account", { tab: "profile-update" }), children: /* @__PURE__ */ jsx(Pencil, { className: "h-7 w-7" }) }) }),
          /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
            /* @__PURE__ */ jsx("h3", { className: "font-semibold", children: instructor.user.name }),
            /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: instructor.designation }),
            /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: instructor.biography })
          ] }),
          /* @__PURE__ */ jsx(InstructorSocials, { instructor, className: "py-0", buttonClass: "w-8 h-8" })
        ] })
      ] }),
      /* @__PURE__ */ jsx("div", { className: "space-y-12", children: evenElements == null ? void 0 : evenElements.map((item, index) => /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "bg-background shadow-card-md h-10 w-10 rounded p-2", children: /* @__PURE__ */ jsx(DynamicIcon, { name: item.icon, className: "text-secondary-foreground h-6 w-6" }) }),
        /* @__PURE__ */ jsx("h3", { className: "pt-4 pb-2 font-semibold", children: item.title }),
        /* @__PURE__ */ jsx("p", { className: "text-muted-foreground text-sm", children: item.description })
      ] }, index)) })
    ] }),
    /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:top-1/2 after:left-1/2 after:h-[290px] after:w-[290px] after:-translate-x-1/2 after:-translate-y-1/2 after:rounded-full after:bg-[rgba(97,95,255,1))] after:blur-[290px] after:content-['']" })
  ] });
};
export {
  Instructor as default
};
