import { jsxs, jsx } from "react/jsx-runtime";
import { S as SidebarProvider, a as Sidebar, b as SidebarInset } from "./sidebar-4chFkdEZ.js";
import { M as Main } from "./main-BlfvuptM.js";
import { g as getCompletedContents, a as getCourseCompletion } from "./utils-Dq7odfJT.js";
import Footer from "./footer-TuAf1457.js";
import { useState, useEffect } from "react";
import Navbar from "./navbar-DSBo4doJ.js";
import ContentList from "./content-list-ZnTldLbd.js";
import ContentSummery from "./content-summery-Cay00RBH.js";
import LessonViewer from "./lesson-viewer-cy3JvEAi.js";
import QuizViewer from "./quiz-viewer-ChTw6a1v.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "lucide-react";
import "./button-CoRGprmX.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "@inertiajs/react";
import "clsx";
import "tailwind-merge";
import "./app-logo-C1ut8-jl.js";
import "lucide-react/dynamic";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./profile-toggle-MdsR9VAt.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "nanoid";
import "./use-screen-B7SDA5zE.js";
import "./live-class-status-BOS7RfOO.js";
import "./tabs-BPACUADK.js";
import "./tabs-CgNNKgka.js";
import "@radix-ui/react-tabs";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./card-DBOrqCcU.js";
import "./progress-DrwO8C5j.js";
import "@radix-ui/react-progress";
import "richtor";
/* empty css                 */
import "./lesson-DNe3ZAvl.js";
import "./lesson-icons-CrjzYJr0.js";
import "./quiz-BYqeSqTK.js";
import "./student-feedback-C84F73Wn.js";
import "./use-lang-44ndmTOc.js";
import "./review-BW8m_km_.js";
import "./delete-modal-CTUf4WRn.js";
import "./dialog-Bzzm0V8u.js";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./table-footer-Cfva3_5Y.js";
import "./route-DlE7FdTW.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./review-edit-Dbw8WNS2.js";
import "./forum-QLP8Ytsa.js";
import "./input-BPdrsFAc.js";
import "./inertia-BtwbgBI3.js";
import "./forum-edit-CB59DwoH.js";
import "./forum-reply-DsLk-Nqn.js";
import "./resource-_YYNOZm7.js";
import "./video-player-DbcUPn7s.js";
import "plyr-react";
/* empty css                */
import "./document-viewer-Cu3KnL-a.js";
import "./embed-viewer-CRjXuKs5.js";
import "./lesson-control-CEkBFSYX.js";
import "./checkbox-DmVJz5lb.js";
import "@radix-ui/react-checkbox";
import "./radio-group-B7ePM9gk.js";
import "@radix-ui/react-radio-group";
const Index = (props) => {
  const { type, watching, watchHistory, direction } = props;
  const [sidebarWidth, setSidebarWidth] = useState("calc(var(--spacing) * 100)");
  const completed = getCompletedContents(watchHistory);
  const completion = getCourseCompletion(props.course, completed);
  useEffect(() => {
    const handleResize = () => {
      if (window.innerWidth < 880) {
        setSidebarWidth("calc(var(--spacing) * 70)");
      } else if (window.innerWidth < 1024) {
        setSidebarWidth("calc(var(--spacing) * 80)");
      } else {
        setSidebarWidth("calc(var(--spacing) * 100)");
      }
    };
    handleResize();
    window.addEventListener("resize", handleResize);
    return () => window.removeEventListener("resize", handleResize);
  }, []);
  return /* @__PURE__ */ jsxs(
    SidebarProvider,
    {
      className: "flex-col",
      style: {
        "--sidebar-width": sidebarWidth
      },
      children: [
        /* @__PURE__ */ jsx(Navbar, {}),
        /* @__PURE__ */ jsxs("div", { className: "flex w-full flex-row-reverse", children: [
          /* @__PURE__ */ jsx(Sidebar, { side: direction === "rtl" ? "left" : "right", className: "top-[60px] shadow-lg", children: /* @__PURE__ */ jsx(ContentList, { completedContents: completed, courseCompletion: completion }) }),
          /* @__PURE__ */ jsx(SidebarInset, { children: /* @__PURE__ */ jsxs(Main, { children: [
            type === "lesson" ? /* @__PURE__ */ jsx(LessonViewer, { lesson: watching }) : /* @__PURE__ */ jsx(QuizViewer, { quiz: watching }),
            /* @__PURE__ */ jsx(ContentSummery, {}),
            /* @__PURE__ */ jsx(Footer, {})
          ] }) })
        ] })
      ]
    }
  );
};
export {
  Index as default
};
