import { jsxs, jsx } from "react/jsx-runtime";
import { C as Card, a as CardHeader, b as CardContent } from "./card-DBOrqCcU.js";
import { s as systemCurrency, c as cn } from "./utils-Dq7odfJT.js";
import { usePage, Link, router } from "@inertiajs/react";
import { Clock, VideoIcon, BadgeCheck } from "lucide-react";
import { C as CheckoutItem } from "./checkout-item-BnelHvjg.js";
import { B as Button } from "./button-CoRGprmX.js";
import { g as getPageSection, S as Section } from "./section-DVceEJ6r.js";
import "react";
import "clsx";
import "tailwind-merge";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./use-lang-44ndmTOc.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "./inertia-BtwbgBI3.js";
import "./icon-picker-dialog-kwu88Bla.js";
import "./icon-picker-CUJAUhoK.js";
import "./debounce-ZFxqVthq.js";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "lucide-react/dynamic";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
const CourseCard3 = ({ course, className }) => {
  const { props } = usePage();
  const { user } = props.auth;
  const { translate } = props;
  const { frontend, common, button } = translate;
  const currency = systemCurrency(props.system.fields["selling_currency"]);
  return /* @__PURE__ */ jsxs(Card, { className: cn(className), children: [
    /* @__PURE__ */ jsx(CardHeader, { className: "p-0", children: /* @__PURE__ */ jsx("div", { className: "relative", children: /* @__PURE__ */ jsx("div", { className: "p-2 pb-0", children: /* @__PURE__ */ jsx(
      Link,
      {
        href: route("course.details", {
          slug: course.slug,
          id: course.id
        }),
        children: /* @__PURE__ */ jsxs("div", { className: "group relative h-[320px] w-full overflow-hidden rounded-lg", children: [
          /* @__PURE__ */ jsx(
            "img",
            {
              src: course.thumbnail || "/assets/images/blank-image.jpg",
              alt: course.title,
              className: "h-full w-full object-cover transition-transform duration-300 group-hover:scale-105",
              onError: (e) => {
                const target = e.target;
                target.src = "/assets/images/blank-image.jpg";
              }
            }
          ),
          /* @__PURE__ */ jsxs("div", { className: "from-primary dark:from-primary-foreground absolute bottom-0 left-1/2 flex h-full w-full -translate-x-1/2 flex-col justify-end bg-gradient-to-t p-4 text-center text-white opacity-0 transition-all duration-200 group-hover:opacity-100", children: [
            /* @__PURE__ */ jsx("h6", { className: "text-2xl font-semibold md:text-3xl", children: course.title }),
            /* @__PURE__ */ jsx("p", { className: "mt-1 md:text-lg", children: course.course_category.title })
          ] })
        ] })
      }
    ) }) }) }),
    /* @__PURE__ */ jsxs(CardContent, { className: "space-y-4 p-5", children: [
      /* @__PURE__ */ jsx("p", { children: course.short_description }),
      /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-3", children: [
        course.pricing_type === "free" ? /* @__PURE__ */ jsxs(
          Button,
          {
            className: "px-5",
            onClick: () => router.post(route("enrollments.store"), {
              user_id: user == null ? void 0 : user.id,
              course_id: course.id,
              enrollment_type: "free"
            }),
            children: [
              /* @__PURE__ */ jsx(Clock, {}),
              " ",
              common.free,
              " | ",
              button.enroll_now
            ]
          }
        ) : /* @__PURE__ */ jsx(CheckoutItem, { item: "course", item_id: course.id, children: /* @__PURE__ */ jsxs(Button, { className: "px-5", children: [
          /* @__PURE__ */ jsx(Clock, {}),
          " ",
          `${currency == null ? void 0 : currency.symbol}${course.price}`,
          " | ",
          button.enroll_now
        ] }) }),
        /* @__PURE__ */ jsxs(
          Button,
          {
            variant: "outline",
            className: "px-5",
            onClick: () => router.get(
              route("course.details", {
                slug: course.slug,
                id: course.id
              })
            ),
            children: [
              /* @__PURE__ */ jsx(VideoIcon, {}),
              " ",
              frontend.course_details
            ]
          }
        )
      ] }),
      /* @__PURE__ */ jsxs("p", { className: "flex items-center gap-2", children: [
        /* @__PURE__ */ jsx(BadgeCheck, { size: 16 }),
        /* @__PURE__ */ jsx("span", { className: "text-sm", children: course.course_category.title })
      ] })
    ] })
  ] });
};
const Hero = () => {
  const { props } = usePage();
  const { page, heroCourses } = props;
  const heroSection = getPageSection(page, "hero");
  const courseLength = (heroCourses == null ? void 0 : heroCourses.length) ?? 0;
  return /* @__PURE__ */ jsxs(Section, { customize: props.customize, pageSection: heroSection, containerClass: "py-20", contentClass: "relative", children: [
    heroCourses.length > 0 ? /* @__PURE__ */ jsx(
      "div",
      {
        className: cn(
          "relative z-10 grid grid-cols-1 items-center gap-x-20",
          courseLength > 1 ? "lg:grid-cols-2" : "lg:grid-cols-1",
          courseLength > 2 ? "gap-y-10" : "gap-y-14"
        ),
        children: heroCourses == null ? void 0 : heroCourses.map((course) => /* @__PURE__ */ jsx(CourseCard3, { course, className: "h-full" }, course.id))
      }
    ) : /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx("p", { className: "text-center font-medium", children: "Top Courses Hero Section. There is no course added." }) }),
    /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:bottom-10 after:left-0 after:h-[240px] after:w-[240px] after:rounded-full after:bg-[rgba(0,167,111,1)] after:blur-[290px] after:content-['']" }),
    /* @__PURE__ */ jsx("div", { className: "after:pointer-events-none after:absolute after:top-10 after:right-0 after:h-[240px] after:w-[240px] after:rounded-full after:bg-[rgba(97,95,255,1))] after:blur-[290px] after:content-['']" })
  ] });
};
export {
  Hero as default
};
