import { jsxs, jsx } from "react/jsx-runtime";
import { D as DataSortModal } from "./data-sort-modal-fNvcILsf.js";
import { D as DeleteModal } from "./delete-modal-CTUf4WRn.js";
import { A as Accordion, a as AccordionItem, b as AccordionTrigger, c as AccordionContent } from "./accordion-DjZKTuzo.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { P as Popover, a as PopoverTrigger, b as PopoverContent } from "./popover-BomUxjap.js";
import { S as Separator } from "./separator-BjFPAtSa.js";
import { usePage, router } from "@inertiajs/react";
import { ChevronDown, FolderOpen, Pencil, Trash2, ListOrdered } from "lucide-react";
import LessonForm from "./lesson-form-BPub2Kwm.js";
import QuestionQuestions from "./question-questions-D2GrqPgL.js";
import QuizForm from "./quiz-form-CjcnwfHb.js";
import SectionForm from "./section-form-Dh87huUv.js";
import ResourceModal from "./resource-modal-vE3GMHxa.js";
import "nprogress";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "@radix-ui/react-accordion";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-popover";
import "@radix-ui/react-separator";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./tabs-BPACUADK.js";
import "./tabs-CgNNKgka.js";
import "@radix-ui/react-tabs";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./radio-group-B7ePM9gk.js";
import "@radix-ui/react-radio-group";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./textarea-M8ToDCeU.js";
import "./file-metadata-CvVo69cP.js";
import "./inertia-BtwbgBI3.js";
import "richtor";
/* empty css                 */
import "./question-form-B_RkYTpp.js";
import "./tag-input-9nM54QOY.js";
import "@yaireo/tagify";
import "./resource-form-e1xxyUlu.js";
import "./resource-list-ZMhElnQD.js";
const Curriculum = () => {
  const { props } = usePage();
  const { translate } = props;
  const { button, dashboard } = translate;
  return /* @__PURE__ */ jsxs(Card, { className: "p-4 sm:p-6", children: [
    /* @__PURE__ */ jsxs("div", { className: "flex flex-wrap items-center gap-4", children: [
      /* @__PURE__ */ jsx(
        SectionForm,
        {
          title: button.add_section,
          handler: /* @__PURE__ */ jsx(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10", children: button.add_section })
        }
      ),
      /* @__PURE__ */ jsx(
        DataSortModal,
        {
          title: button.sort,
          data: props.course.sections,
          handler: /* @__PURE__ */ jsx(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10", children: button.sort_section }),
          onOrderChange: (newOrder) => {
            router.post(
              route("section.sort"),
              {
                sortedData: newOrder
              },
              { preserveScroll: true }
            );
          },
          renderContent: (item) => /* @__PURE__ */ jsx(Card, { className: "w-full px-4 py-3", children: /* @__PURE__ */ jsx("p", { children: item.title }) })
        }
      )
    ] }),
    /* @__PURE__ */ jsx(Separator, { className: "my-6" }),
    /* @__PURE__ */ jsx(Accordion, { type: "single", collapsible: true, className: "space-y-4", children: props.course.sections.map((section, index) => /* @__PURE__ */ jsxs(AccordionItem, { value: section.id, className: "w-full overflow-hidden rounded-lg border", children: [
      /* @__PURE__ */ jsx(AccordionTrigger, { className: "[&[data-state=open]]:bg-muted px-4 py-3 text-base hover:no-underline", children: /* @__PURE__ */ jsxs("div", { className: "flex w-full items-center justify-between pr-4", children: [
        /* @__PURE__ */ jsxs("span", { children: [
          index + 1,
          ". ",
          section.title
        ] }),
        /* @__PURE__ */ jsx("div", { onClick: (e) => e.stopPropagation(), children: /* @__PURE__ */ jsxs(Popover, { children: [
          /* @__PURE__ */ jsx(PopoverTrigger, { children: /* @__PURE__ */ jsxs(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10 px-2.5", children: [
            /* @__PURE__ */ jsx("span", { children: "Section Menu" }),
            /* @__PURE__ */ jsx(ChevronDown, { className: "h-4 w-4" })
          ] }) }),
          /* @__PURE__ */ jsxs(PopoverContent, { align: "end", className: "flex w-[160px] flex-col space-y-1 p-2", children: [
            /* @__PURE__ */ jsx(
              LessonForm,
              {
                title: button.add_lesson,
                sectionId: section.id,
                handler: /* @__PURE__ */ jsx(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10 h-8 w-full", children: /* @__PURE__ */ jsx("span", { children: button.add_lesson }) })
              }
            ),
            /* @__PURE__ */ jsx(
              DataSortModal,
              {
                title: dashboard.sort_items,
                data: section.section_lessons,
                handler: /* @__PURE__ */ jsx(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10 h-8 w-full", children: /* @__PURE__ */ jsx("span", { children: "Sort Lessons" }) }),
                onOrderChange: (newOrder) => {
                  router.post(
                    route("lesson.sort"),
                    {
                      sortedData: newOrder
                    },
                    { preserveScroll: true }
                  );
                },
                renderContent: (lesson) => /* @__PURE__ */ jsx(Card, { className: "w-full px-4 py-3", children: /* @__PURE__ */ jsx("p", { children: lesson.title }) })
              }
            ),
            /* @__PURE__ */ jsx(
              QuizForm,
              {
                title: button.add_quiz,
                sectionId: section.id,
                handler: /* @__PURE__ */ jsx(Button, { variant: "ghost", className: "bg-muted hover:bg-muted-foreground/10 h-8 w-full", children: /* @__PURE__ */ jsx("span", { children: button.add_quiz }) })
              }
            ),
            /* @__PURE__ */ jsx(
              SectionForm,
              {
                title: dashboard.update_section,
                section,
                handler: /* @__PURE__ */ jsx(Button, { variant: "secondary", className: "h-8 w-full", children: /* @__PURE__ */ jsx("span", { children: dashboard.update_section }) })
              }
            ),
            /* @__PURE__ */ jsx(
              DeleteModal,
              {
                routePath: route("section.delete", {
                  id: section.id
                }),
                actionComponent: /* @__PURE__ */ jsx(
                  Button,
                  {
                    variant: "ghost",
                    className: "bg-destructive/8 hover:bg-destructive/6 text-destructive hover:text-destructive h-8 w-full",
                    children: button.delete_section
                  }
                )
              }
            )
          ] })
        ] }) })
      ] }) }),
      /* @__PURE__ */ jsxs(AccordionContent, { className: "space-y-4 p-4", children: [
        section.section_lessons.length > 0 ? section.section_lessons.map((lesson) => /* @__PURE__ */ jsxs("div", { className: "group border-border flex w-full items-center justify-between rounded-md border px-4 py-3", children: [
          /* @__PURE__ */ jsx("p", { children: lesson.title }),
          /* @__PURE__ */ jsxs("div", { className: "invisible flex items-center gap-2 group-hover:visible", children: [
            /* @__PURE__ */ jsx(
              ResourceModal,
              {
                lesson,
                title: "Lesson Resources",
                handler: /* @__PURE__ */ jsxs(Button, { variant: "secondary", className: "h-7 px-2", children: [
                  /* @__PURE__ */ jsx(FolderOpen, { className: "h-3 w-3" }),
                  " ",
                  /* @__PURE__ */ jsx("span", { children: "Resource" })
                ] })
              }
            ),
            /* @__PURE__ */ jsx(
              LessonForm,
              {
                lesson,
                sectionId: section.id,
                title: dashboard.update_lesson,
                handler: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "h-7 w-7", children: /* @__PURE__ */ jsx(Pencil, { className: "h-3 w-3" }) })
              }
            ),
            /* @__PURE__ */ jsx(
              DeleteModal,
              {
                routePath: route("lesson.delete", {
                  id: lesson.id
                }),
                actionComponent: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "text-destructive h-7 w-7", children: /* @__PURE__ */ jsx(Trash2, { className: "h-3 w-3" }) })
              }
            )
          ] })
        ] }, lesson.id)) : /* @__PURE__ */ jsx("div", { className: "text-muted-foreground py-4 text-center text-sm", children: "No lessons found in this section." }),
        section.section_quizzes.map((quiz) => /* @__PURE__ */ jsxs("div", { className: "group border-border flex w-full items-center justify-between rounded-md border px-4 py-3", children: [
          /* @__PURE__ */ jsx("p", { children: quiz.title }),
          /* @__PURE__ */ jsxs("div", { className: "invisible flex items-center gap-2 group-hover:visible", children: [
            /* @__PURE__ */ jsx(
              QuestionQuestions,
              {
                quiz,
                title: button.quiz_questions,
                handler: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "h-7 w-7", children: /* @__PURE__ */ jsx(ListOrdered, { className: "h-3 w-3" }) })
              }
            ),
            /* @__PURE__ */ jsx(
              DeleteModal,
              {
                routePath: route("quiz.delete", {
                  id: quiz.id
                }),
                actionComponent: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "text-destructive h-7 w-7", children: /* @__PURE__ */ jsx(Trash2, { className: "h-3 w-3" }) })
              }
            ),
            /* @__PURE__ */ jsx(
              QuizForm,
              {
                quiz,
                title: dashboard.update_quiz,
                sectionId: section.id,
                handler: /* @__PURE__ */ jsx(Button, { size: "icon", variant: "secondary", className: "h-7 w-7", children: /* @__PURE__ */ jsx(Pencil, { className: "h-3 w-3" }) })
              }
            )
          ] })
        ] }, quiz.id))
      ] })
    ] }, section.id)) })
  ] });
};
export {
  Curriculum as default
};
