import { jsx, jsxs } from "react/jsx-runtime";
import { C as Combobox } from "./combobox-BCj7gyvQ.js";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { L as LoadingButton } from "./loading-button-C9msud_X.js";
import { T as TagInput } from "./tag-input-9nM54QOY.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { I as Input } from "./input-BPdrsFAc.js";
import { L as Label } from "./label-BKAgVFnB.js";
import { T as Textarea } from "./textarea-M8ToDCeU.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { o as onHandleChange } from "./inertia-BtwbgBI3.js";
import { useForm } from "@inertiajs/react";
import "./button-CoRGprmX.js";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "cmdk";
import "lucide-react";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "@yaireo/tagify";
import "@radix-ui/react-label";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./route-DlE7FdTW.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
const CreateUpdate = ({ instructor, users, translate }) => {
  const initialOptions = (instructor == null ? void 0 : instructor.skills) ? typeof instructor.skills === "string" ? JSON.parse(instructor.skills) : instructor.skills : [];
  const { dashboard, input, button } = translate;
  const { data, setData, post, processing, errors, reset } = useForm({
    user_id: "",
    designation: (instructor == null ? void 0 : instructor.designation) || "",
    skills: initialOptions,
    biography: (instructor == null ? void 0 : instructor.biography) || "",
    resume: null
  });
  const handleSubmit = (e) => {
    e.preventDefault();
    if (instructor) {
      post(route("become-instructor.update", { id: instructor.id }));
    } else {
      post(route("become-instructor.store"), {
        onSuccess: () => {
          reset();
        }
      });
    }
  };
  const transformedUsers = users.map((user) => ({
    value: user.id.toString(),
    label: user.name
  }));
  return /* @__PURE__ */ jsx(Card, { className: "p-4 sm:p-6", children: /* @__PURE__ */ jsxs("form", { onSubmit: handleSubmit, className: "relative space-y-4", children: [
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsxs(Label, { children: [
        dashboard.course_instructor,
        " *"
      ] }),
      /* @__PURE__ */ jsx(Combobox, { data: transformedUsers, placeholder: input.select, onSelect: (selected) => setData("user_id", selected.value) }),
      /* @__PURE__ */ jsx(InputError, { message: errors.user_id })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.designation }),
      /* @__PURE__ */ jsx(Input, { type: "text", name: "designation", onChange: (e) => onHandleChange(e, setData), placeholder: input.designation_placeholder }),
      /* @__PURE__ */ jsx(InputError, { message: errors.designation })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.resume }),
      /* @__PURE__ */ jsx(Input, { readOnly: true, type: "file", name: "resume", onChange: (e) => onHandleChange(e, setData) }),
      /* @__PURE__ */ jsx(InputError, { message: errors.resume })
    ] }),
    /* @__PURE__ */ jsxs("div", { children: [
      /* @__PURE__ */ jsx(Label, { children: input.skills }),
      /* @__PURE__ */ jsx(TagInput, { defaultTags: data.skills, placeholder: input.skills, onChange: (values) => setData("skills", values) })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "pb-3", children: [
      /* @__PURE__ */ jsx(Label, { children: input.biography }),
      /* @__PURE__ */ jsx(
        Textarea,
        {
          rows: 5,
          required: true,
          name: "biography",
          value: data.biography,
          onChange: (e) => onHandleChange(e, setData),
          placeholder: input.biography_placeholder
        }
      ),
      /* @__PURE__ */ jsx(InputError, { message: errors.biography })
    ] }),
    /* @__PURE__ */ jsx(LoadingButton, { loading: processing, className: "mt-2", children: instructor ? button.update : button.submit })
  ] }) });
};
CreateUpdate.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  CreateUpdate as default
};
