import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { C as Card, a as CardHeader, b as CardContent } from "./card-DBOrqCcU.js";
import { c as cn } from "./utils-Dq7odfJT.js";
import { usePage, Link, Head } from "@inertiajs/react";
import { B as ButtonGradientPrimary } from "./button-gradient-primary-CdBh9JnF.js";
import { A as Avatar, a as AvatarImage, b as AvatarFallback } from "./avatar-DPWl5zBC.js";
import { P as Progress } from "./progress-DrwO8C5j.js";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { S as Separator } from "./separator-BjFPAtSa.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import Layout from "./layout-D45zMvt_.js";
import CourseAssignments from "./course-assignments-BMRULR5X.js";
import CourseCertificate from "./course-certificate-D6Gn7TnX.js";
import CourseLiveClasses from "./course-live-classes-CmrEokYM.js";
import CourseModules from "./course-modules-DbLw75FR.js";
import CourseQuizzes from "./course-quizzes-D2yKlj7k.js";
import CourseResources from "./course-resources-mFC0DfSM.js";
import "react";
import "clsx";
import "tailwind-merge";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "@radix-ui/react-avatar";
import "@radix-ui/react-progress";
import "@radix-ui/react-separator";
import "@radix-ui/react-tabs";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "lucide-react";
import "./use-screen-B7SDA5zE.js";
import "./landing-layout-CrHLE-uC.js";
import "./index-1bYjjcki.js";
import "./app-logo-C1ut8-jl.js";
import "lucide-react/dynamic";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./use-auth-8FvJer_G.js";
import "./appearance-B5i6uI_j.js";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./profile-toggle-MdsR9VAt.js";
import "nanoid";
import "./tab-lists-C_IvT-cN.js";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "@tanstack/react-table";
import "./assignment-columns-DRfK6Zcv.js";
import "./badge-CnqJovSa.js";
import "./assignment-dialog-35Cv6tjl.js";
import "./dialog-Bzzm0V8u.js";
import "./assignment-details-BD_KqM29.js";
import "richtor";
/* empty css                 */
import "./assignment-submission-D2qpp0po.js";
import "./assignment-submission-form-DWjocxat.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./textarea-M8ToDCeU.js";
import "./dynamic-marksheet-BNfUA6u3.js";
import "./radio-group-B7ePM9gk.js";
import "@radix-ui/react-radio-group";
import "jspdf";
import "./alert-BKVD7z68.js";
import "./live-class-status-BOS7RfOO.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./lesson-Ctj5bUVI.js";
import "./lesson-icons-CrjzYJr0.js";
import "./quiz-Bu0FwfT0.js";
import "./quiz-status-BYlRRtJW.js";
import "./quiz-result-dialog-BQsUAkvr.js";
const CourseCard7 = ({ course, watch_history, completion, className }) => {
  const { props } = usePage();
  const { translate } = props;
  const { frontend, button } = translate;
  return /* @__PURE__ */ jsxs(Card, { className: cn("flex flex-col justify-between overflow-hidden !border md:flex-row", className), children: [
    /* @__PURE__ */ jsx(CardHeader, { className: "h-[200px] w-full max-w-[360px] p-0", children: /* @__PURE__ */ jsx(
      "img",
      {
        src: course.thumbnail || "/assets/images/blank-image.jpg",
        alt: course.title,
        className: "h-full w-full object-cover",
        onError: (e) => {
          const target = e.target;
          target.src = "/assets/images/blank-image.jpg";
        }
      }
    ) }),
    /* @__PURE__ */ jsxs(CardContent, { className: "flex w-full flex-col justify-between p-4", children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx("div", { className: "mb-3 flex items-center gap-2", children: /* @__PURE__ */ jsxs("div", { className: "flex items-center gap-2", children: [
          /* @__PURE__ */ jsxs(Avatar, { className: "h-8 w-8", children: [
            /* @__PURE__ */ jsx(AvatarImage, { src: course.instructor.user.photo || "", alt: course.instructor.user.name, className: "object-cover" }),
            /* @__PURE__ */ jsx(AvatarFallback, { children: "IM" })
          ] }),
          /* @__PURE__ */ jsx("p", { className: "text-sm font-medium", children: course.instructor.user.name })
        ] }) }),
        /* @__PURE__ */ jsx("p", { className: "hover:text-secondary-foreground text-sm font-semibold", children: course.title })
      ] }),
      /* @__PURE__ */ jsxs("div", { className: "space-y-2", children: [
        /* @__PURE__ */ jsxs("div", { className: "w-full space-y-2 pt-4 pb-2", children: [
          /* @__PURE__ */ jsxs("p", { className: "text-muted-foreground flex items-center justify-between text-sm font-medium", children: [
            /* @__PURE__ */ jsx("span", { children: frontend.progress }),
            /* @__PURE__ */ jsxs("span", { children: [
              (completion == null ? void 0 : completion.completion) ?? 0,
              "%"
            ] })
          ] }),
          /* @__PURE__ */ jsx(Progress, { value: Number((completion == null ? void 0 : completion.completion) ?? 0), className: "h-1.5" })
        ] }),
        watch_history && /* @__PURE__ */ jsx(
          ButtonGradientPrimary,
          {
            asChild: true,
            shadow: false,
            containerClass: "w-full",
            className: "to-primary-light hover:to-primary-light h-9 w-full",
            children: /* @__PURE__ */ jsx(
              Link,
              {
                href: route("course.player", {
                  type: watch_history.current_watching_type,
                  watch_history: watch_history.id,
                  lesson_id: watch_history.current_watching_id
                }),
                children: button.continue
              }
            )
          }
        )
      ] })
    ] })
  ] });
};
const Course = (props) => {
  const { tab, course, watchHistory, completion } = props;
  const tabs = [
    {
      value: "modules",
      label: "Modules"
    },
    {
      value: "live_classes",
      label: "Live Classes"
    },
    {
      value: "assignments",
      label: "Assignments"
    },
    {
      value: "quizzes",
      label: "Quizzes"
    },
    {
      value: "resources",
      label: "Resources"
    },
    {
      value: "certificate",
      label: "Certificate"
    }
  ];
  const renderContent = () => {
    switch (tab) {
      case "modules":
        return /* @__PURE__ */ jsx(CourseModules, {});
      case "live_classes":
        return /* @__PURE__ */ jsx(CourseLiveClasses, {});
      case "assignments":
        return /* @__PURE__ */ jsx(CourseAssignments, {});
      case "quizzes":
        return /* @__PURE__ */ jsx(CourseQuizzes, {});
      case "resources":
        return /* @__PURE__ */ jsx(CourseResources, {});
      case "certificate":
        return /* @__PURE__ */ jsx(CourseCertificate, {});
      default:
        return /* @__PURE__ */ jsx(Fragment, {});
    }
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(Head, { title: course.title }),
    /* @__PURE__ */ jsx(CourseCard7, { course, watch_history: watchHistory, completion }),
    /* @__PURE__ */ jsx(Card, { className: "mt-6", children: /* @__PURE__ */ jsxs(Tabs, { value: tab, className: "bg-card w-full overflow-hidden rounded-md", children: [
      /* @__PURE__ */ jsx("div", { className: "overflow-x-auto overflow-y-hidden", children: /* @__PURE__ */ jsx(TabsList, { className: "bg-transparent px-0 py-6", children: tabs.map(({ label, value }) => {
        return /* @__PURE__ */ jsx(
          TabsTrigger,
          {
            value,
            className: "border-primary data-[state=active]:!bg-muted data-[state=active]:before:bg-primary relative flex cursor-pointer items-center justify-start gap-3 rounded-none bg-transparent px-8 py-4 text-start !shadow-none before:absolute before:right-0 before:bottom-0 before:left-0 before:h-1 before:rounded-t-xl data-[state=active]:before:content-['.']",
            asChild: true,
            children: /* @__PURE__ */ jsx(
              Link,
              {
                href: route("student.course.show", {
                  id: course.id,
                  tab: value
                }),
                children: /* @__PURE__ */ jsx("span", { children: label })
              }
            )
          },
          value
        );
      }) }) }),
      /* @__PURE__ */ jsx(Separator, { className: "mt-[1px]" }),
      /* @__PURE__ */ jsx(TabsContent, { value: tab, className: "m-0 p-5", children: renderContent() })
    ] }) })
  ] });
};
Course.layout = (page) => /* @__PURE__ */ jsx(Layout, { children: page, tab: "courses" });
export {
  Course as default
};
