import { jsx } from "react/jsx-runtime";
import Categories from "./categories-BYbHlgRu.js";
import Courses from "./courses-5R4Cp7Zk.js";
import Instructors from "./instructors-1LifCooB.js";
import "./table-header-BdDXN7Km.js";
import "./table-Lb16Ctse.js";
import "react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "@tanstack/react-table";
import "@inertiajs/react";
import "./categories-table-columns-ChwvyQC8.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "lucide-react";
import "./table-filter-CO4tlWp0.js";
import "./table-page-size-CjbVFJnO.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./debounce-ZFxqVthq.js";
import "./table-footer-CtfXptA8.js";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./courses-table-columns-BUN0Bak9.js";
import "./instructors-table-columns-DCqbKGAL.js";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
const Contents = ({ contents, section_slug, selectedIds = [], onSelectChange }) => {
  const renderField = () => {
    switch (section_slug) {
      case "hero":
      case "top_course":
      case "top_courses":
      case "new_courses":
        return /* @__PURE__ */ jsx(Courses, { courses: contents, selectedIds, onCourseSelect: onSelectChange });
      case "top_categories":
      case "category_courses":
        return /* @__PURE__ */ jsx(Categories, { categories: contents, selectedIds, onCourseSelect: onSelectChange });
      case "top_instructors":
        return /* @__PURE__ */ jsx(Instructors, { instructors: contents, selectedIds, onCourseSelect: onSelectChange });
      case "blogs":
        return /* @__PURE__ */ jsx("h1", { children: "Blogs" });
      default:
        return null;
    }
  };
  return /* @__PURE__ */ jsx("div", { className: "rounded-md border", children: renderField() });
};
export {
  Contents as default
};
