import { jsxs, jsx } from "react/jsx-runtime";
import { S as StudentFeedback } from "./student-feedback-C84F73Wn.js";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { S as Separator } from "./separator-BjFPAtSa.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { usePage } from "@inertiajs/react";
import { useState, useEffect } from "react";
import { Renderer } from "richtor";
/* empty css                 */
import ReviewForm from "./review-BW8m_km_.js";
import Forum from "./forum-QLP8Ytsa.js";
import Resource from "./resource-_YYNOZm7.js";
import "./progress-DrwO8C5j.js";
import "@radix-ui/react-progress";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./use-lang-44ndmTOc.js";
import "lucide-react";
import "@radix-ui/react-separator";
import "@radix-ui/react-tabs";
import "./delete-modal-CTUf4WRn.js";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./table-footer-Cfva3_5Y.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./route-DlE7FdTW.js";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./textarea-M8ToDCeU.js";
import "date-fns";
import "sonner";
import "./review-edit-Dbw8WNS2.js";
import "./input-BPdrsFAc.js";
import "./inertia-BtwbgBI3.js";
import "./forum-edit-CB59DwoH.js";
import "./forum-reply-DsLk-Nqn.js";
const ContentSummery = () => {
  const { props } = usePage();
  const { translate, type } = props;
  const { button } = translate;
  const [isResource, setIsResource] = useState(false);
  useEffect(() => {
    if (type === "lesson") {
      const watching = props.watching;
      if (watching.resources.length > 0) {
        setIsResource(true);
      }
    }
  }, [props.watching]);
  const tabs = [
    {
      value: "summery",
      label: button.summery
    },
    {
      value: "resource",
      label: "Resource"
    },
    {
      value: "forum",
      label: button.forum
    },
    {
      value: "review",
      label: button.review
    }
  ];
  return /* @__PURE__ */ jsxs(Tabs, { defaultValue: "summery", className: "mx-auto grid w-full max-w-5xl overflow-hidden rounded-md pt-1 pb-10", children: [
    /* @__PURE__ */ jsx("div", { className: "overflow-x-auto overflow-y-hidden", children: /* @__PURE__ */ jsx(TabsList, { className: "bg-transparent px-0 py-6", children: tabs.map(({ label, value }) => {
      if (value === "resource" && !isResource) {
        return null;
      }
      return /* @__PURE__ */ jsx(
        TabsTrigger,
        {
          value,
          className: "border-primary data-[state=active]:!bg-muted data-[state=active]:before:bg-primary relative flex cursor-pointer items-center justify-start gap-3 rounded-none bg-transparent px-8 py-4 text-start !shadow-none before:absolute before:right-0 before:bottom-0 before:left-0 before:h-1 before:rounded-t-xl data-[state=active]:before:content-['.']",
          children: /* @__PURE__ */ jsx("span", { children: label })
        },
        value
      );
    }) }) }),
    /* @__PURE__ */ jsx(Separator, { className: "mt-[1px]" }),
    /* @__PURE__ */ jsx(TabsContent, { value: "summery", className: "m-0 p-5", children: /* @__PURE__ */ jsx(Renderer, { value: props.watching.summary }) }),
    isResource && /* @__PURE__ */ jsx(TabsContent, { value: "resource", className: "m-0 p-5", children: /* @__PURE__ */ jsx(Resource, {}) }),
    /* @__PURE__ */ jsx(TabsContent, { value: "forum", className: "m-0 p-5", children: /* @__PURE__ */ jsx(Forum, {}) }),
    /* @__PURE__ */ jsxs(TabsContent, { value: "review", className: "m-0 space-y-6 p-5", children: [
      /* @__PURE__ */ jsx(StudentFeedback, { totalReviews: props.totalReviews }),
      /* @__PURE__ */ jsx(ReviewForm, {})
    ] })
  ] });
};
export {
  ContentSummery as default
};
