import { jsx, jsxs } from "react/jsx-runtime";
import { T as Tabs } from "./tabs-BPACUADK.js";
import { T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { g as getQueryParams } from "./route-DlE7FdTW.js";
import { usePage, router } from "@inertiajs/react";
import Google from "./google-ChME0P5g.js";
import Recaptcha from "./recaptcha-BEYMJLN3.js";
import "react";
import "@radix-ui/react-tabs";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "./sidebar-4chFkdEZ.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "lucide-react";
import "./button-CoRGprmX.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./use-lang-44ndmTOc.js";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./switch-BqKLcKEJ.js";
import "./switch-BZ5JBg1u.js";
import "@radix-ui/react-switch";
import "./card-DBOrqCcU.js";
import "./input-BPdrsFAc.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./inertia-BtwbgBI3.js";
const Auth = ({ auths }) => {
  const { props, url } = usePage();
  const params = getQueryParams(url);
  const { translate } = props;
  const { common } = translate;
  const tabs = auths.map((auth) => {
    let Component;
    switch (auth.sub_type) {
      case "google":
        Component = Google;
        break;
      case "recaptcha":
        Component = Recaptcha;
        break;
      default:
        Component = ({ auth: auth2 }) => /* @__PURE__ */ jsx("div", { children: "No component found" });
        break;
    }
    return {
      ...auth,
      Component
    };
  });
  return /* @__PURE__ */ jsx("section", { className: "md:px-3", children: /* @__PURE__ */ jsxs(Tabs, { value: params["tab"] ?? tabs[0].sub_type, className: "grid grid-rows-1 gap-5 md:grid-cols-4", children: [
    /* @__PURE__ */ jsx("div", { children: /* @__PURE__ */ jsx(TabsList, { className: "horizontal-tabs-list", children: tabs.map(({ id, title, sub_type }) => /* @__PURE__ */ jsx(
      TabsTrigger,
      {
        value: sub_type,
        className: "horizontal-tabs-trigger",
        onClick: () => router.get(
          route("settings.auth0", {
            tab: sub_type
          })
        ),
        children: title
      },
      id
    )) }) }),
    /* @__PURE__ */ jsx("div", { className: "md:col-span-3", children: tabs.map((auth) => /* @__PURE__ */ jsx(TabsContent, { value: auth.sub_type, className: "m-0", children: /* @__PURE__ */ jsx(auth.Component, { auth }, auth.id) }, auth.id)) })
  ] }) });
};
Auth.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Auth as default
};
