import { jsxs, jsx, Fragment } from "react/jsx-runtime";
import { B as Button } from "./button-CoRGprmX.js";
import { D as Dialog, a as DialogTrigger, b as DialogContent, c as DialogHeader } from "./dialog-Bzzm0V8u.js";
import { c as Tabs, T as TabsList, a as TabsTrigger, b as TabsContent } from "./tabs-CgNNKgka.js";
import { CheckCircle } from "lucide-react";
import { useState } from "react";
import AssignmentDetails from "./assignment-details-BD_KqM29.js";
import AssignmentSubmission from "./assignment-submission-D2qpp0po.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "@radix-ui/react-dialog";
import "@radix-ui/react-tabs";
import "date-fns";
import "richtor";
/* empty css                 */
import "./badge-CnqJovSa.js";
import "./assignment-submission-form-DWjocxat.js";
import "./chunked-uploader-input-DSIqX-Yc.js";
import "./input-BPdrsFAc.js";
import "axios";
import "sonner";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "./textarea-M8ToDCeU.js";
import "@inertiajs/react";
const AssignmentDialog = ({ assignment }) => {
  const [open, setOpen] = useState(false);
  const hasSubmission = assignment.submissions && assignment.submissions.length > 0;
  const isDeadlinePassed = (deadline) => {
    if (!deadline) return false;
    return /* @__PURE__ */ new Date() > new Date(deadline);
  };
  const deadlinePassed = isDeadlinePassed(assignment.deadline);
  return /* @__PURE__ */ jsxs(Dialog, { open, onOpenChange: setOpen, children: [
    /* @__PURE__ */ jsx(DialogTrigger, { asChild: true, children: /* @__PURE__ */ jsx(Button, { variant: "ghost", size: "sm", className: "h-8 gap-2", children: hasSubmission ? /* @__PURE__ */ jsxs(Fragment, { children: [
      /* @__PURE__ */ jsx(CheckCircle, { className: "h-4 w-4" }),
      /* @__PURE__ */ jsx("span", { children: "Check" })
    ] }) : /* @__PURE__ */ jsx("span", { children: "Submit" }) }) }),
    /* @__PURE__ */ jsx(DialogContent, { className: "max-h-[90vh] max-w-4xl p-0", children: /* @__PURE__ */ jsxs(Tabs, { defaultValue: "details", className: "w-full", children: [
      /* @__PURE__ */ jsx(DialogHeader, { className: "p-6 pb-0", children: /* @__PURE__ */ jsxs(TabsList, { className: "grid h-11 w-full grid-cols-2", children: [
        /* @__PURE__ */ jsx(TabsTrigger, { value: "details", className: "h-9", children: "Assignment Details" }),
        /* @__PURE__ */ jsx(TabsTrigger, { value: deadlinePassed ? "" : "submit", className: "h-9", disabled: deadlinePassed, children: "Assignment Submission" })
      ] }) }),
      /* @__PURE__ */ jsxs("div", { className: "max-h-[calc(90vh-92px)] overflow-y-auto p-6", children: [
        /* @__PURE__ */ jsx(TabsContent, { value: "details", className: "m-0", children: /* @__PURE__ */ jsx(AssignmentDetails, { assignment, deadlinePassed }) }),
        !deadlinePassed && /* @__PURE__ */ jsx(TabsContent, { value: "submit", className: "m-0", children: /* @__PURE__ */ jsx(AssignmentSubmission, { assignment, setDialogOpen: setOpen }) })
      ] })
    ] }) })
  ] });
};
export {
  AssignmentDialog as default
};
