import { jsxs, jsx } from "react/jsx-runtime";
import { T as TableFilter } from "./table-filter-BKvPriu7.js";
import { T as TableFooter } from "./table-footer-Cfva3_5Y.js";
import { T as TableHeader } from "./table-header-BdDXN7Km.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { T as Table, a as TableBody, b as TableRow, c as TableCell } from "./table-Lb16Ctse.js";
import { D as DashboardLayout } from "./layout-Dek-rKv4.js";
import { useReactTable, getFilteredRowModel, getSortedRowModel, getCoreRowModel, flexRender } from "@tanstack/react-table";
import * as React from "react";
import ApplicationsTableColumn from "./applications-table-columns-Bg98MduD.js";
import "./use-lang-44ndmTOc.js";
import "@inertiajs/react";
import "./debounce-ZFxqVthq.js";
import "./route-DlE7FdTW.js";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "lucide-react";
import "./button-CoRGprmX.js";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dropdown-menu-DONmDWr6.js";
import "@radix-ui/react-dropdown-menu";
import "./scroll-area-Dgj2o23v.js";
import "@radix-ui/react-scroll-area";
import "./table-page-size-CjbVFJnO.js";
import "./sidebar-4chFkdEZ.js";
import "./separator-BjFPAtSa.js";
import "@radix-ui/react-separator";
import "./sheet-BrIPI26w.js";
import "@radix-ui/react-dialog";
import "./tooltip-BatcEs-T.js";
import "@radix-ui/react-tooltip";
import "./main-BlfvuptM.js";
import "./sonner-0gqP4YyH.js";
import "next-themes";
import "sonner";
import "./appearance-B5i6uI_j.js";
import "./language-pQjimNcB.js";
import "./notification-Bii6lhkq.js";
import "./popover-BomUxjap.js";
import "@radix-ui/react-popover";
import "date-fns";
import "./app-logo-C1ut8-jl.js";
import "./accordion-DjZKTuzo.js";
import "@radix-ui/react-accordion";
import "./avatar-DPWl5zBC.js";
import "@radix-ui/react-avatar";
import "./dialog-Bzzm0V8u.js";
import "./document-viewer-Cu3KnL-a.js";
import "./application-approval-BYUBBctU.js";
import "./input-error-CBKwRgzN.js";
import "./loading-button-C9msud_X.js";
import "./label-BKAgVFnB.js";
import "@radix-ui/react-label";
import "./select-DLRJE4Jo.js";
import "@radix-ui/react-select";
import "richtor";
/* empty css                 */
const Applications = (props) => {
  var _a;
  const [sorting, setSorting] = React.useState([]);
  const { translate } = props;
  const { dashboard } = translate;
  const table = useReactTable({
    data: props.applications.data,
    columns: ApplicationsTableColumn(props.translate),
    onSortingChange: setSorting,
    getCoreRowModel: getCoreRowModel(),
    getSortedRowModel: getSortedRowModel(),
    getFilteredRowModel: getFilteredRowModel(),
    state: { sorting }
  });
  return /* @__PURE__ */ jsxs(Card, { children: [
    /* @__PURE__ */ jsx(
      TableFilter,
      {
        data: props.applications,
        title: dashboard.instructor_list,
        globalSearch: true,
        tablePageSizes: [10, 15, 20, 25],
        routeName: "instructors.applications"
      }
    ),
    /* @__PURE__ */ jsxs(Table, { className: "border-border border-y", children: [
      /* @__PURE__ */ jsx(TableHeader, { table, tableHeadClass: "px-6" }),
      /* @__PURE__ */ jsx(TableBody, { children: table.getRowModel().rows.map((row) => /* @__PURE__ */ jsx(TableRow, { "data-state": row.getIsSelected() && "selected", children: row.getVisibleCells().map((cell) => /* @__PURE__ */ jsx(TableCell, { className: "px-6", children: flexRender(cell.column.columnDef.cell, cell.getContext()) }, cell.id)) }, row.id)) })
    ] }),
    ((_a = table.getRowModel().rows) == null ? void 0 : _a.length) <= 0 && /* @__PURE__ */ jsx("p", { className: "border-border w-full border-b px-6 py-10 text-center", children: dashboard.no_results_found }),
    /* @__PURE__ */ jsx(TableFooter, { className: "p-5 sm:p-7", routeName: "instructors.applications", paginationInfo: props.applications })
  ] });
};
Applications.layout = (page) => /* @__PURE__ */ jsx(DashboardLayout, { children: page });
export {
  Applications as default
};
