import { jsx, Fragment, jsxs } from "react/jsx-runtime";
import { I as InputError } from "./input-error-CBKwRgzN.js";
import { B as Button } from "./button-CoRGprmX.js";
import { C as Card } from "./card-DBOrqCcU.js";
import { W as WarningModal } from "./warning-modal-C5lHqMjB.js";
import { useForm } from "@inertiajs/react";
import { Download, RefreshCw } from "lucide-react";
import "./utils-Dq7odfJT.js";
import "clsx";
import "tailwind-merge";
import "react";
import "@radix-ui/react-slot";
import "class-variance-authority";
import "./dialog-Bzzm0V8u.js";
import "@radix-ui/react-dialog";
import "./loading-button-C9msud_X.js";
const ApplicationBackup = () => {
  const { post, errors, processing } = useForm({});
  useForm({});
  return /* @__PURE__ */ jsx(Fragment, { children: /* @__PURE__ */ jsxs(Card, { className: "p-4 sm:p-6", children: [
    /* @__PURE__ */ jsxs("div", { className: "mb-4", children: [
      /* @__PURE__ */ jsxs("h2", { className: "flex items-center gap-2 text-xl font-semibold", children: [
        /* @__PURE__ */ jsx(Download, { className: "h-5 w-5" }),
        "Application Backup"
      ] }),
      /* @__PURE__ */ jsx("p", { className: "text-muted-foreground mt-1 text-sm", children: "Create a complete backup of your application including files and database" })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: "space-y-6", children: [
      /* @__PURE__ */ jsx("div", { className: "dark:bg-secondary dark:border-border rounded-lg border border-blue-200 bg-blue-50 p-4", children: /* @__PURE__ */ jsxs("div", { className: "flex items-start", children: [
        /* @__PURE__ */ jsx("div", { className: "flex-shrink-0", children: /* @__PURE__ */ jsx(Download, { className: "h-5 w-5 text-blue-600" }) }),
        /* @__PURE__ */ jsxs("div", { className: "ml-3", children: [
          /* @__PURE__ */ jsx("h3", { className: "text-sm font-medium text-blue-800", children: "What will be backed up?" }),
          /* @__PURE__ */ jsx("div", { className: "mt-2 text-sm text-blue-700", children: /* @__PURE__ */ jsxs("ul", { className: "list-inside list-disc space-y-1", children: [
            /* @__PURE__ */ jsxs("li", { children: [
              /* @__PURE__ */ jsx("strong", { children: "Source Code:" }),
              " All application files and code"
            ] }),
            /* @__PURE__ */ jsxs("li", { children: [
              /* @__PURE__ */ jsx("strong", { children: "Database:" }),
              " Complete MySQL database dump"
            ] }),
            /* @__PURE__ */ jsxs("li", { children: [
              /* @__PURE__ */ jsx("strong", { children: "Configuration:" }),
              " Environment and config files"
            ] }),
            /* @__PURE__ */ jsxs("li", { children: [
              /* @__PURE__ */ jsx("strong", { children: "Assets:" }),
              " Uploaded media and public files"
            ] })
          ] }) }),
          /* @__PURE__ */ jsx("div", { className: "mt-3 text-xs text-blue-600", children: /* @__PURE__ */ jsxs("p", { children: [
            /* @__PURE__ */ jsx("strong", { children: "Note:" }),
            " Every time refresh server before backup."
          ] }) })
        ] })
      ] }) }),
      errors && Object.keys(errors).length > 0 && /* @__PURE__ */ jsx("div", { className: "space-y-1", children: Object.entries(errors).map(([key, error]) => /* @__PURE__ */ jsx(InputError, { message: String(error) }, key)) }),
      /* @__PURE__ */ jsxs("div", { className: "flex flex-col gap-3 sm:flex-row", children: [
        /* @__PURE__ */ jsx(
          WarningModal,
          {
            method: "post",
            routePath: route("system.refresh"),
            title: "Are you sure to refresh your app?",
            actionComponent: /* @__PURE__ */ jsxs(Button, { type: "button", variant: "secondary", children: [
              /* @__PURE__ */ jsx(RefreshCw, { className: "h-4 w-4" }),
              /* @__PURE__ */ jsx("span", { children: "Refresh App" })
            ] })
          }
        ),
        /* @__PURE__ */ jsx(
          WarningModal,
          {
            method: "post",
            routePath: route("system.backup"),
            title: "Are you sure to create app backup?",
            actionComponent: /* @__PURE__ */ jsxs(Button, { children: [
              /* @__PURE__ */ jsx(Download, { className: "h-4 w-4" }),
              /* @__PURE__ */ jsx("span", { children: "Create Backup" })
            ] })
          }
        )
      ] })
    ] })
  ] }) });
};
export {
  ApplicationBackup as default
};
